/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class SimpleContext
implements Context {
    protected Map<String, Object> bindings = new HashMap<String, Object>();
    private Hashtable<String, Object> environment;

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object rc = this.bindings.get(name);
        if (rc == null) {
            throw new NameNotFoundException(name);
        }
        return rc;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (this.bindings.containsKey(name)) {
            throw new NameAlreadyBoundException(name);
        }
        this.bindings.put(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.bindings.put(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        if (this.bindings.remove(name) == null) {
            throw new NameNotFoundException(name);
        }
    }

    public void rename(Attributes.Name oldName, Attributes.Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        if (!this.bindings.containsKey(oldName)) {
            throw new NameNotFoundException(oldName);
        }
        if (this.bindings.containsKey(newName)) {
            throw new NameAlreadyBoundException(newName);
        }
        this.bindings.put(newName, this.bindings.remove(oldName));
    }

    public NamingEnumeration<NameClassPair> list(Attributes.Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        if (name.length() > 0) {
            throw new OperationNotSupportedException("subcontexts not supported");
        }
        final Iterator<Map.Entry<String, Object>> i = this.bindings.entrySet().iterator();
        return new NamingEnumeration<NameClassPair>(){

            @Override
            public NameClassPair next() {
                Map.Entry e = (Map.Entry)i.next();
                return new NameClassPair((String)e.getKey(), e.getValue().getClass().getName());
            }

            @Override
            public boolean hasMore() {
                return i.hasNext();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasMore();
            }

            @Override
            public NameClassPair nextElement() {
                return this.next();
            }
        };
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        if (name.length() > 0) {
            throw new OperationNotSupportedException("subcontexts not supported");
        }
        final Iterator<Map.Entry<String, Object>> i = this.bindings.entrySet().iterator();
        return new NamingEnumeration<Binding>(){

            @Override
            public Binding next() {
                Map.Entry e = (Map.Entry)i.next();
                return new Binding((String)e.getKey(), e.getValue());
            }

            @Override
            public boolean hasMore() {
                return i.hasNext();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasMore();
            }

            @Override
            public Binding nextElement() {
                return this.next();
            }
        };
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("subcontexts not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("subcontexts not supported");
    }

    public Object lookupLink(Attributes.Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(Attributes.Name name) {
        return this.getNameParser(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) {
        throw new UnsupportedOperationException("getNameParser");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String key, Object val) {
        this.initEnvironment();
        return this.environment.put(key, val);
    }

    @Override
    public Object removeFromEnvironment(String key) {
        this.initEnvironment();
        return this.environment.remove(key);
    }

    public Hashtable<String, Object> getEnvironment() {
        this.initEnvironment();
        return this.environment;
    }

    private void initEnvironment() {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }
}

