/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.IOUtils;

public class ObjectToOutputHandler
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ObjectToOutputHandler() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.fromType(Serializable.class));
        this.setReturnDataType(DataType.fromType(OutputHandler.class));
    }

    @Override
    public Object doTransform(final Object src, final Charset encoding) throws TransformerException {
        if (src instanceof String) {
            return new OutputHandler(){

                @Override
                public void write(Event event, OutputStream out) throws IOException {
                    out.write(((String)src).getBytes(encoding));
                }
            };
        }
        if (src instanceof byte[]) {
            return new OutputHandler(){

                @Override
                public void write(Event event, OutputStream out) throws IOException {
                    out.write((byte[])src);
                }
            };
        }
        if (src instanceof InputStream) {
            return new OutputHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(Event event, OutputStream out) throws IOException {
                    try (InputStream is = (InputStream)src;){
                        IOUtils.copyLarge(is, out);
                    }
                }
            };
        }
        if (src instanceof Serializable) {
            return new OutputHandler(){

                @Override
                public void write(Event event, OutputStream out) throws IOException {
                    ObjectToOutputHandler.this.muleContext.getObjectSerializer().getExternalProtocol().serialize(src, out);
                }
            };
        }
        throw new TransformerException(I18nMessageFactory.createStaticMessage((String)("Unable to convert " + src.getClass() + " to OutputHandler.")));
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

