/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.core.transformer.simple.SerializableToByteArray;
import org.mule.runtime.core.util.IOUtils;

public class ObjectToByteArray
extends SerializableToByteArray {
    public ObjectToByteArray() {
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.fromType(OutputHandler.class));
        this.setReturnDataType(DataType.BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        try {
            if (src instanceof String) {
                return src.toString().getBytes(outputEncoding);
            }
            if (src instanceof InputStream) {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                try (InputStream is = (InputStream)src;){
                    IOUtils.copyLarge(is, byteOut);
                }
                return byteOut.toByteArray();
            }
            if (src instanceof OutputHandler) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                try {
                    ((OutputHandler)src).write(Event.getCurrentEvent(), bytes);
                    return bytes.toByteArray();
                }
                catch (IOException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
        return super.doTransform(src, outputEncoding);
    }
}

