/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.metadata;

import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;

public class DefaultMetadataContext
implements MetadataContext {
    private final Optional<ConfigurationInstance> configInstance;
    private final ConnectionManager connectionManager;
    private final MetadataCache cache;
    private final ClassTypeLoader typeLoader;

    public DefaultMetadataContext(Optional<ConfigurationInstance> configInstance, ConnectionManager connectionManager, MetadataCache cache, ClassTypeLoader typeLoader) {
        this.configInstance = configInstance;
        this.connectionManager = connectionManager;
        this.cache = cache;
        this.typeLoader = typeLoader;
    }

    public <C> Optional<C> getConfig() {
        return this.configInstance.map(Optional::of);
    }

    public <C> Optional<C> getConnection() throws ConnectionException {
        ConfigurationInstance config = this.configInstance.orElse(null);
        if (config == null || !config.getConnectionProvider().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.connectionManager.getConnection(config.getValue()).getConnection());
    }

    public MetadataCache getCache() {
        return this.cache;
    }

    public ClassTypeLoader getTypeLoader() {
        return this.typeLoader;
    }

    public BaseTypeBuilder getTypeBuilder() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    }
}

