/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionExceptionCode;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CachedConnectionHandler<C>
implements ConnectionHandlerAdapter<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedConnectionHandler.class);
    private final ConnectionProvider<C> connectionProvider;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final MuleContext muleContext;
    private C connection;

    public CachedConnectionHandler(ConnectionProvider<C> connectionProvider, MuleContext muleContext) {
        this.connectionProvider = connectionProvider;
        this.muleContext = muleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getConnection() throws ConnectionException {
        C oldConnection;
        this.readLock.lock();
        try {
            if (this.connection != null && this.validateConnection(this.connection).isValid()) {
                C c = this.connection;
                return c;
            }
            oldConnection = this.connection;
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.connection != null) {
                if (this.connection != oldConnection) {
                    C c = this.connection;
                    return c;
                }
                this.disconnectAndCleanConnection(this.connection);
            }
            C c = this.connection = this.createConnection();
            return c;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private C createConnection() throws ConnectionException {
        LifecycleUtils.assertNotStopping(this.muleContext, "Mule is shutting down... Cannot establish new connections");
        this.connection = this.connectionProvider.connect();
        return this.connection;
    }

    public void release() {
    }

    @Override
    public void close() throws MuleException {
        this.writeLock.lock();
        try {
            if (this.connectionProvider != null && this.connection != null) {
                this.connectionProvider.disconnect(this.connection);
            }
        }
        finally {
            this.connection = null;
            this.writeLock.unlock();
        }
    }

    protected ConnectionValidationResult validateConnection(C connection) {
        ConnectionValidationResult validationResult = null;
        try {
            validationResult = this.connectionProvider.validate(connection);
        }
        catch (Exception e) {
            validationResult = ConnectionValidationResult.failure((String)"Error validating connection. Unexpected exception was thrown by the extension when validating the connection", (ConnectionExceptionCode)ConnectionExceptionCode.UNKNOWN, (Exception)e);
        }
        if (validationResult == null) {
            String errorMessage = "Error validating connection. validate() method from the connection provider can not return a null ConnectionValidationResult";
            validationResult = ConnectionValidationResult.failure((String)errorMessage, (ConnectionExceptionCode)ConnectionExceptionCode.UNKNOWN, (Exception)new ConnectionException(errorMessage));
        }
        return validationResult;
    }

    private void disconnectAndCleanConnection(C connection) {
        try {
            this.connectionProvider.disconnect(connection);
        }
        catch (Exception e) {
            LOGGER.debug("Error disconnecting the extension's connection", (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }
}

