/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.functional;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    public static <L, R> Either<L, R> left(L value) {
        return new Either(Optional.of(value), Optional.empty());
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either(Optional.empty(), Optional.of(value));
    }

    private Either(Optional<L> l, Optional<R> r) {
        this.left = l;
        this.right = r;
    }

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> lFunc) {
        return new Either<T, R>(this.left.map(lFunc), this.right);
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> rFunc) {
        return new Either<L, T>(this.left, this.right.map(rFunc));
    }

    public void apply(Consumer<? super L> lFunc, Consumer<? super R> rFunc) {
        this.left.ifPresent(lFunc);
        this.right.ifPresent(rFunc);
    }

    public boolean isLeft() {
        return this.left.isPresent();
    }

    public boolean isRight() {
        return this.right.isPresent();
    }

    public L getLeft() {
        return this.left.get();
    }

    public R getRight() {
        return this.right.get();
    }
}

