/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.expression;

import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.config.i18n.CoreMessages;

public class ExpressionConfig {
    private String unParsedExpression;
    private String expression;
    private String fullExpression;
    private String expressionPrefix = "#[";
    private String expressionPostfix = "]";
    private volatile boolean parsed = false;

    public ExpressionConfig() {
    }

    public ExpressionConfig(String expression) {
        this(expression, "#[", "]");
    }

    public ExpressionConfig(String expression, String expressionPrefix, String expressionPostfix) {
        this.setExpression(expression);
        this.expressionPostfix = expressionPostfix;
        this.expressionPrefix = expressionPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String expressionString) {
        if (this.parsed) {
            return;
        }
        ExpressionConfig expressionConfig = this;
        synchronized (expressionConfig) {
            if (this.parsed) {
                return;
            }
            this.doParse(expressionString);
            this.parsed = true;
        }
    }

    private void doParse(String expressionString) {
        if (expressionString.startsWith(this.expressionPrefix)) {
            expressionString = expressionString.substring(this.expressionPrefix.length());
            expressionString = expressionString.substring(0, expressionString.length() - this.expressionPostfix.length());
        }
        this.expression = expressionString;
    }

    public void validate(ExpressionManager expressionManager) {
        if (this.expression == null) {
            this.parse(this.unParsedExpression);
        }
        if (this.expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
    }

    public String getFullExpression(ExpressionManager expressionManager) {
        if (this.fullExpression == null) {
            if (this.expression == null) {
                this.parse(this.unParsedExpression);
            }
            this.validate(expressionManager);
            this.fullExpression = this.expressionPrefix + this.expression + this.expressionPostfix;
        }
        return this.fullExpression;
    }

    public String getExpression() {
        if (this.expression == null) {
            this.parse(this.unParsedExpression);
        }
        return this.expression;
    }

    public void setExpression(String expression) {
        this.unParsedExpression = expression;
        this.expression = null;
        this.fullExpression = null;
        this.parsed = false;
    }
}

