/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.resource.spi.work.Work;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.MessageProcessTemplate;
import org.mule.runtime.core.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.NotificationFiringProcessingPhase;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.core.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.execution.ValidationPhase;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleFlowProcessingPhase
extends NotificationFiringProcessingPhase<ModuleFlowProcessingPhaseTemplate> {
    private final PolicyManager policyManager;
    protected static transient Logger logger = LoggerFactory.getLogger(ModuleFlowProcessingPhase.class);

    public ModuleFlowProcessingPhase(PolicyManager policyManager) {
        this.policyManager = policyManager;
    }

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof ModuleFlowProcessingPhaseTemplate;
    }

    @Override
    public void runPhase(final ModuleFlowProcessingPhaseTemplate template, final MessageProcessContext messageProcessContext, final PhaseResultNotifier phaseResultNotifier) {
        Work flowExecutionWork = new Work(){

            public void release() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MessageSource messageSource = messageProcessContext.getMessageSource();
                    ComponentIdentifier sourceIdentifier = messageProcessContext.getSourceIdentifier();
                    Event templateEvent = Event.builder(DefaultEventContext.create(messageProcessContext.getFlowConstruct(), sourceIdentifier.getNamespace())).message((InternalMessage)template.getMessage()).build();
                    Optional<SourcePolicy> policy = ModuleFlowProcessingPhase.this.policyManager.findSourcePolicyInstance(templateEvent.getContext().getId(), sourceIdentifier);
                    Event flowExecutionResponse = null;
                    try {
                        MessagingExceptionHandler exceptionHandler = messageProcessContext.getFlowConstruct().getExceptionListener();
                        Processor nextOperation = this.createFlowExecutionProcessor(messageSource, exceptionHandler);
                        flowExecutionResponse = policy.isPresent() ? policy.get().process(templateEvent, nextOperation, template) : nextOperation.process(templateEvent);
                        ModuleFlowProcessingPhase.this.fireNotification(messageSource, flowExecutionResponse, messageProcessContext.getFlowConstruct(), 805);
                        ResponseCompletionCallback responseCompletationCallback = ModuleFlowProcessingPhase.this.createResponseCompletationCallback(phaseResultNotifier, exceptionHandler);
                        if (flowExecutionResponse == null) {
                            flowExecutionResponse = Event.builder(templateEvent).message((InternalMessage)Message.builder().nullPayload().build()).build();
                        }
                        Map responseParameters = ModuleFlowProcessingPhase.this.generateSuccessfulResponseParameters(sourceIdentifier, policy, flowExecutionResponse, template);
                        Optional<SourcePolicyParametersTransformer> policySourceParametersTransformer = ModuleFlowProcessingPhase.this.policyManager.lookupSourceParametersTransformer(sourceIdentifier);
                        Function errorResponseParametersFunction = ModuleFlowProcessingPhase.this.generateErrorResponseParametersFunction(policy, policySourceParametersTransformer, template);
                        template.sendResponseToClient(flowExecutionResponse, responseParameters, errorResponseParametersFunction, responseCompletationCallback);
                    }
                    catch (Exception e) {
                        MessagingException me;
                        if (e instanceof MessagingException) {
                            me = (MessagingException)((Object)e);
                        } else if (flowExecutionResponse != null) {
                            me = new MessagingException(flowExecutionResponse, e);
                        } else {
                            throw e;
                        }
                        me.setProcessedEvent(ExceptionUtils.createErrorEvent(me.getEvent(), messageSource, me, messageProcessContext.getErrorTypeLocator()));
                        ModuleFlowProcessingPhase.this.fireNotification(messageSource, me.getEvent(), messageProcessContext.getFlowConstruct(), 806);
                        template.sendFailureResponseToClient(me, (Map)ModuleFlowProcessingPhase.this.generateErrorResponseParametersFunction(policy, ModuleFlowProcessingPhase.this.policyManager.lookupSourceParametersTransformer(sourceIdentifier), template).apply(me.getEvent()), ModuleFlowProcessingPhase.this.createSendFailureResponseCompletationCallback(phaseResultNotifier));
                    }
                    finally {
                        ModuleFlowProcessingPhase.this.policyManager.disposePoliciesResources(templateEvent.getContext().getId());
                    }
                }
                catch (Exception e) {
                    phaseResultNotifier.phaseFailure(e);
                }
            }

            private Processor createFlowExecutionProcessor(MessageSource messageSource, MessagingExceptionHandler exceptionHandler) {
                return muleEvent -> {
                    try {
                        TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(messageProcessContext.getFlowConstruct().getMuleContext(), messageProcessContext.getFlowConstruct(), messageProcessContext.getTransactionConfig() == null ? new MuleTransactionConfig() : messageProcessContext.getTransactionConfig(), exceptionHandler);
                        Object response = transactionTemplate.execute(() -> {
                            ModuleFlowProcessingPhase.this.fireNotification(messageSource, muleEvent, messageProcessContext.getFlowConstruct(), 801);
                            return template.routeEvent(muleEvent);
                        });
                        return response;
                    }
                    catch (MuleException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new DefaultMuleException(e);
                    }
                };
            }
        };
        if (messageProcessContext.supportsAsynchronousProcessing()) {
            try {
                messageProcessContext.getFlowExecutionExecutor().execute((Runnable)flowExecutionWork);
            }
            catch (Exception e) {
                phaseResultNotifier.phaseFailure(e);
            }
        } else {
            flowExecutionWork.run();
        }
    }

    private Function<Event, Map<String, Object>> generateErrorResponseParametersFunction(Optional<SourcePolicy> policy, Optional<SourcePolicyParametersTransformer> policySourceParametersTransformer, ModuleFlowProcessingPhaseTemplate template) {
        return failureResponseEvent -> {
            Map<String, Object> failureResponseParameters = policy.isPresent() && policySourceParametersTransformer.isPresent() ? ((SourcePolicyParametersTransformer)policySourceParametersTransformer.get()).fromMessageToErrorResponseParameters(failureResponseEvent.getMessage()) : template.getFailedExecutionResponseParametersFunction().apply((Event)failureResponseEvent);
            return failureResponseParameters;
        };
    }

    private Map<String, Object> generateSuccessfulResponseParameters(ComponentIdentifier sourceIdentifier, Optional<SourcePolicy> policy, Event flowExecutionResponse, ModuleFlowProcessingPhaseTemplate template) throws MuleException {
        Map<String, Object> responseParameters = policy.isPresent() ? this.policyManager.lookupSourceParametersTransformer(sourceIdentifier).get().fromMessageToSuccessResponseParameters(flowExecutionResponse.getMessage()) : template.getSuccessfulExecutionResponseParametersFunction().apply(flowExecutionResponse);
        return responseParameters;
    }

    private ResponseCompletionCallback createSendFailureResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                phaseResultNotifier.phaseFailure((Exception)((Object)e));
                return event;
            }
        };
    }

    private ResponseCompletionCallback createResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier, final MessagingExceptionHandler exceptionListener) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                return ModuleFlowProcessingPhase.this.executeCallback(() -> {
                    Event handleException = exceptionListener.handleException(e, event);
                    phaseResultNotifier.phaseSuccessfully();
                    return handleException;
                }, phaseResultNotifier);
            }
        };
    }

    private Event executeCallback(Callback callback, PhaseResultNotifier phaseResultNotifier) {
        try {
            return callback.execute();
        }
        catch (Exception callbackException) {
            phaseResultNotifier.phaseFailure(callbackException);
            throw new MuleRuntimeException((Throwable)callbackException);
        }
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }

    private static interface Callback {
        public Event execute() throws Exception;
    }
}

