/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.MessageProcessorPathResolver;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessorExecutionInterceptor;

class MessageProcessorNotificationExecutionInterceptor
implements MessageProcessorExecutionInterceptor {
    private MessageProcessorExecutionInterceptor next;
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;

    MessageProcessorNotificationExecutionInterceptor(MessageProcessorExecutionInterceptor next) {
        this.next = next;
    }

    MessageProcessorNotificationExecutionInterceptor() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Event execute(Processor messageProcessor, Event event) throws MessagingException {
        Event event2;
        ServerNotificationManager notificationManager = this.muleContext.getNotificationManager();
        boolean fireNotification = event.isNotificationsEnabled();
        if (fireNotification) {
            MessageProcessorNotificationExecutionInterceptor.fireNotification(notificationManager, this.flowConstruct, event, messageProcessor, null, 1601);
        }
        Event eventToProcess = event;
        Event result = null;
        MessagingException exceptionThrown = null;
        Event.setCurrentEvent(eventToProcess);
        try {
            result = this.next == null ? messageProcessor.process(eventToProcess) : this.next.execute(messageProcessor, eventToProcess);
            if (!fireNotification) return result;
            event2 = result != null ? result : event;
        }
        catch (MessagingException e) {
            try {
                exceptionThrown = e;
                throw e;
                catch (MuleException e2) {
                    exceptionThrown = new MessagingException(event, e2, messageProcessor);
                    throw exceptionThrown;
                }
            }
            catch (Throwable throwable) {
                if (!fireNotification) throw throwable;
                MessageProcessorNotificationExecutionInterceptor.fireNotification(notificationManager, this.flowConstruct, result != null ? result : event, messageProcessor, exceptionThrown, 1602);
                throw throwable;
            }
        }
        MessageProcessorNotificationExecutionInterceptor.fireNotification(notificationManager, this.flowConstruct, event2, messageProcessor, exceptionThrown, 1602);
        return result;
    }

    public static void fireNotification(ServerNotificationManager serverNotificationManager, FlowConstruct flowConstruct, Event event, Processor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class) && flowConstruct instanceof MessageProcessorPathResolver && ((MessageProcessorPathResolver)((Object)flowConstruct)).getProcessorPath(processor) != null) {
            serverNotificationManager.fireNotification(new MessageProcessorNotification(flowConstruct, event, processor, exceptionThrown, action));
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.next != null) {
            this.next.setMuleContext(context);
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        if (this.next != null) {
            this.next.setFlowConstruct(flowConstruct);
        }
    }
}

