/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.context.notification.ExceptionStrategyNotification;
import org.mule.runtime.core.exception.AbstractExceptionListener;
import org.mule.runtime.core.exception.ErrorTypeMatcher;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.message.DefaultExceptionPayload;
import org.mule.runtime.core.processor.AbstractRequestResponseMessageProcessor;
import org.mule.runtime.core.routing.requestreply.ReplyToPropertyRequestReplyReplier;
import org.mule.runtime.core.transaction.TransactionCoordination;

public abstract class TemplateOnErrorHandler
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private MessageProcessorChain configuredMessageProcessors;
    private Processor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();
    private ErrorTypeMatcher errorTypeMatcher = null;
    private String when;
    private boolean handleException;

    @Override
    public final Event handleException(MessagingException exception, Event event) {
        try {
            return new ExceptionMessageProcessor(exception, this.muleContext, this.flowConstruct).process(event);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)((Object)exception)).setHandled(true);
        }
    }

    protected Event processReplyTo(Event event, Exception e) {
        try {
            return this.replyToMessageProcessor.process(event);
        }
        catch (MuleException ex) {
            this.logFatal(event, ex);
            return event;
        }
    }

    protected Event nullifyExceptionPayloadIfRequired(Event event) {
        if (this.handleException) {
            return Event.builder(event).error(null).message(InternalMessage.builder(event.getMessage()).exceptionPayload(null).build()).build();
        }
        return event;
    }

    private void processStatistics() {
        FlowConstructStatistics statistics = this.flowConstruct.getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    protected Event route(Event event, MessagingException t) throws MessagingException {
        if (!this.getMessageProcessors().isEmpty()) {
            try {
                event = Event.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload((Throwable)((Object)t))).build()).build();
                Event result = this.configuredMessageProcessors.process(event);
                return result;
            }
            catch (MessagingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessagingException(event, e);
            }
        }
        return event;
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        this.configuredMessageProcessors = MessageProcessors.newChain(this.getMessageProcessors());
        this.configuredMessageProcessors.setFlowConstruct(this.flowConstruct);
        this.configuredMessageProcessors.setMuleContext(muleContext);
    }

    public void setWhen(String when) {
        this.when = when;
    }

    @Override
    public boolean accept(Event event) {
        return this.acceptsAll() || this.acceptsErrorType(event) || this.when != null && this.muleContext.getExpressionManager().evaluateBoolean(this.when, event, this.flowConstruct);
    }

    private boolean acceptsErrorType(Event event) {
        return this.errorTypeMatcher != null && this.errorTypeMatcher.match(((Error)event.getError().get()).getErrorType());
    }

    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && this.when == null;
    }

    protected Event afterRouting(MessagingException exception, Event event) {
        return event;
    }

    protected Event beforeRouting(MessagingException exception, Event event) {
        return event;
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public void setErrorTypeMatcher(ErrorTypeMatcher errorTypeMatcher) {
        this.errorTypeMatcher = errorTypeMatcher;
    }

    private class ExceptionMessageProcessor
    extends AbstractRequestResponseMessageProcessor {
        private MessagingException exception;

        public ExceptionMessageProcessor(MessagingException exception, MuleContext muleContext, FlowConstruct flowConstruct) {
            this.exception = exception;
            this.setMuleContext(muleContext);
            this.setFlowConstruct(flowConstruct);
        }

        @Override
        protected Event processRequest(Event request) throws MuleException {
            this.muleContext.getNotificationManager().fireNotification(new ExceptionStrategyNotification(request, this.flowConstruct, 2001));
            TemplateOnErrorHandler.this.fireNotification((Exception)((Object)this.exception));
            TemplateOnErrorHandler.this.logException((Throwable)((Object)this.exception), request);
            TemplateOnErrorHandler.this.processStatistics();
            TemplateOnErrorHandler.this.markExceptionAsHandledIfRequired((Exception)((Object)this.exception));
            return TemplateOnErrorHandler.this.beforeRouting(this.exception, request);
        }

        @Override
        protected Event processResponse(Event response, Event request) throws MuleException {
            TemplateOnErrorHandler.this.processOutboundRouterStatistics();
            response = TemplateOnErrorHandler.this.afterRouting(this.exception, response);
            if (response != null) {
                response = TemplateOnErrorHandler.this.processReplyTo(response, (Exception)((Object)this.exception));
                TemplateOnErrorHandler.this.closeStream(response.getMessage());
                return TemplateOnErrorHandler.this.nullifyExceptionPayloadIfRequired(response);
            }
            return response;
        }

        @Override
        protected Event processNext(Event event) throws MuleException {
            return TemplateOnErrorHandler.this.route(event, this.exception);
        }

        @Override
        protected Event processCatch(Event event, MessagingException exception) throws MessagingException {
            try {
                this.logger.error("Exception during exception strategy execution");
                TemplateOnErrorHandler.this.doLogException((Throwable)((Object)exception));
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
            catch (Exception ex) {
                this.logger.warn(ex.getMessage());
            }
            throw exception;
        }

        @Override
        protected void processFinally(Event event, MessagingException exception) {
            this.muleContext.getNotificationManager().fireNotification(new ExceptionStrategyNotification(event, this.flowConstruct, 2002));
        }
    }
}

