/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessageRedeliveredException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.RedeliveryExceeded;
import org.mule.runtime.core.exception.TemplateOnErrorHandler;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    private RedeliveryExceeded redeliveryExceeded;
    private Integer maxRedeliveryAttempts;

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.redeliveryExceeded);
        super.doInitialise(muleContext);
    }

    public void setRedeliveryExceeded(RedeliveryExceeded redeliveryExceeded) {
        this.redeliveryExceeded = redeliveryExceeded;
    }

    public void setMaxRedeliveryAttempts(Integer maxRedeliveryAttempts) {
        this.maxRedeliveryAttempts = maxRedeliveryAttempts;
    }

    public Integer getMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts;
    }

    public boolean hasMaxRedeliveryAttempts() {
        return this.maxRedeliveryAttempts != null;
    }

    @Override
    protected Event beforeRouting(MessagingException exception, Event event) {
        if (!this.isRedeliveryExhausted((Exception)((Object)exception))) {
            this.rollback((Exception)((Object)exception));
        }
        return event;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        ArrayList<Processor> messageProcessors = new ArrayList<Processor>(super.getMessageProcessors().size() + (this.redeliveryExceeded == null ? 0 : this.redeliveryExceeded.getMessageProcessors().size()));
        messageProcessors.addAll(super.getMessageProcessors());
        if (this.redeliveryExceeded != null) {
            messageProcessors.addAll(this.redeliveryExceeded.getMessageProcessors());
        }
        return messageProcessors;
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        return exception instanceof MessageRedeliveredException;
    }

    @Override
    protected Event route(Event event, MessagingException t) throws MessagingException {
        Event resultEvent = event;
        if (this.isRedeliveryExhausted((Exception)((Object)t))) {
            if (this.redeliveryExceeded != null) {
                this.markExceptionAsHandled((Exception)((Object)t));
                try {
                    resultEvent = this.redeliveryExceeded.process(event);
                }
                catch (MuleException e) {
                    if (e instanceof MessagingException) {
                        throw (MessagingException)e;
                    }
                    throw new MessagingException(event, e);
                }
            } else {
                this.logger.info("Message redelivery exhausted. No redelivery exhausted actions configured. Message consumed.");
            }
        } else {
            resultEvent = super.route(event, t);
        }
        return resultEvent;
    }

    @Override
    protected Event processReplyTo(Event event, Exception e) {
        if (this.isRedeliveryExhausted(e)) {
            return super.processReplyTo(event, e);
        }
        return event;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
        if (this.redeliveryExceeded != null) {
            this.redeliveryExceeded.setFlowConstruct(flowConstruct);
        }
    }
}

