/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.ExceptionHelper;
import org.mule.runtime.core.routing.filters.RegExFilter;
import org.mule.runtime.core.routing.filters.WildcardFilter;

public class MessagingException
extends MuleException {
    public static final String PAYLOAD_INFO_KEY = "Payload";
    public static final String PAYLOAD_TYPE_INFO_KEY = "Payload Type";
    private static final long serialVersionUID = 6941498759267936649L;
    protected transient InternalMessage muleMessage;
    protected final transient Event event;
    protected transient Event processedEvent;
    private boolean causeRollback;
    private boolean handled;
    private transient Processor failingMessageProcessor;

    @Deprecated
    public MessagingException(I18nMessage message, InternalMessage muleMessage, MuleContext context) {
        super(message);
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message, context));
    }

    public MessagingException(I18nMessage message, Event event) {
        super(message);
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, Event event, Processor failingMessageProcessor) {
        super(message);
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(message, null));
    }

    @Deprecated
    public MessagingException(I18nMessage message, InternalMessage muleMessage, MuleContext context, Throwable cause) {
        super(message, cause);
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message, context));
    }

    public MessagingException(I18nMessage message, Event event, Throwable cause) {
        super(message, cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(I18nMessage message, Event event, Throwable cause, Processor failingMessageProcessor) {
        super(message, cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(message, null));
    }

    public MessagingException(Event event, Throwable cause) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(this.getI18nMessage(), null));
    }

    public MessagingException(Event event, Throwable cause, Processor failingMessageProcessor) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(this.getI18nMessage(), null));
    }

    protected String generateMessage(I18nMessage message, MuleContext muleContext) {
        StringBuilder buf = new StringBuilder(80);
        if (message != null) {
            buf.append(message.getMessage()).append(".");
        }
        if (this.muleMessage != null) {
            if (MuleException.isVerboseExceptions()) {
                Object payload = this.muleMessage.getPayload().getValue();
                if (this.muleMessage.getPayload().getDataType().isStreamType()) {
                    this.addInfo(PAYLOAD_INFO_KEY, StringUtils.abbreviate((String)payload.toString(), (int)1000));
                } else if (payload != null) {
                    this.addInfo(PAYLOAD_TYPE_INFO_KEY, this.muleMessage.getPayload().getDataType().getType().getName());
                    if (muleContext != null) {
                        try {
                            this.addInfo(PAYLOAD_INFO_KEY, muleContext.getTransformationService().transform(this.muleMessage, DataType.STRING).getPayload().getValue());
                        }
                        catch (Exception e) {
                            this.addInfo(PAYLOAD_INFO_KEY, String.format("%s while getting payload: %s", e.getClass().getName(), e.getMessage()));
                        }
                        this.addInfo(PAYLOAD_INFO_KEY, this.muleMessage.toString());
                    }
                } else {
                    this.addInfo(PAYLOAD_TYPE_INFO_KEY, Objects.toString(null));
                    this.addInfo(PAYLOAD_INFO_KEY, Objects.toString(null));
                }
            }
        } else {
            buf.append("The current Message is null!");
            this.addInfo(PAYLOAD_INFO_KEY, Objects.toString(null));
        }
        return buf.toString();
    }

    @Deprecated
    public InternalMessage getMuleMessage() {
        if (this.getEvent() != null) {
            return this.getEvent().getMessage();
        }
        return this.muleMessage;
    }

    public Event getEvent() {
        return this.processedEvent != null ? this.processedEvent : this.event;
    }

    public void setProcessedEvent(Event processedEvent) {
        if (processedEvent != null) {
            this.processedEvent = processedEvent;
            this.extractMuleMessage(processedEvent);
        } else {
            this.processedEvent = null;
            this.muleMessage = null;
        }
    }

    public boolean causedBy(Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy((Throwable)((Object)this), causeException -> {
            if (e.isAssignableFrom(causeException.getClass())) {
                return causeException;
            }
            return null;
        }) != null;
    }

    public boolean causedExactlyBy(Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy((Throwable)((Object)this), causeException -> {
            if (causeException.getClass().equals(e)) {
                return causeException;
            }
            return null;
        }) != null;
    }

    public Exception getCauseException() {
        Object rootException = ExceptionHelper.getRootException((Throwable)((Object)this));
        if (rootException == null) {
            rootException = this;
        }
        return (Exception)rootException;
    }

    public boolean causeMatches(String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("regex cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy((Throwable)((Object)this), e -> {
            WildcardFilter wildcardFilter = new WildcardFilter(regex);
            if (wildcardFilter.accept(e.getClass().getName())) {
                return e;
            }
            try {
                RegExFilter regExFilter = new RegExFilter(regex);
                if (regExFilter.accept(e.getClass().getName())) {
                    return e;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }) != null;
    }

    public boolean causedRollback() {
        return this.causeRollback;
    }

    public void setCauseRollback(boolean causeRollback) {
        this.causeRollback = causeRollback;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean handled() {
        return this.handled;
    }

    public Processor getFailingMessageProcessor() {
        return this.failingMessageProcessor;
    }

    protected void extractMuleMessage(Event event) {
        this.muleMessage = event == null ? null : event.getMessage();
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.failingMessageProcessor instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.failingMessageProcessor);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean failingMessageProcessorWasSerialized = in.readBoolean();
        if (failingMessageProcessorWasSerialized) {
            this.failingMessageProcessor = (Processor)in.readObject();
        }
    }
}

