/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.message.ErrorTypeBuilder;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class ErrorTypeRepository {
    protected static final ErrorType ANY_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("ANY").build();
    private Map<ComponentIdentifier, ErrorType> errorTypes = new HashMap<ComponentIdentifier, ErrorType>();

    public ErrorTypeRepository() {
        this.errorTypes.put(new ComponentIdentifier.Builder().withNamespace(Errors.CORE_NAMESPACE_NAME).withName("ANY").build(), ANY_ERROR_TYPE);
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorTypeBuilder errorTypeBuilder = ErrorTypeBuilder.builder().namespace(errorTypeIdentifier.getNamespace()).identifier(errorTypeIdentifier.getName()).parentErrorType(parentErrorType);
        ErrorType errorType = errorTypeBuilder.build();
        if (this.errorTypes.put(errorTypeIdentifier, errorType) != null) {
            throw new IllegalStateException(String.format("An error type with identifier %s already exists", errorTypeIdentifier));
        }
        return errorType;
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        return Optional.ofNullable(this.errorTypes.get(errorTypeComponentIdentifier));
    }

    public ErrorType getAnyErrorType() {
        return ANY_ERROR_TYPE;
    }
}

