/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.map.HashedMap;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.ExceptionMapper;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class ErrorTypeLocator {
    private ExceptionMapper defaultExceptionMapper;
    private Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers;

    private ErrorTypeLocator(ExceptionMapper defaultExceptionMapper, Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers) {
        this.defaultExceptionMapper = defaultExceptionMapper;
        this.componentExceptionMappers = componentExceptionMappers;
    }

    public ErrorType lookupErrorType(Throwable exception) {
        return this.lookupErrorType(exception.getClass());
    }

    public ErrorType lookupErrorType(Class<? extends Throwable> exceptionType) {
        return this.defaultExceptionMapper.resolveErrorType(exceptionType).get();
    }

    public ErrorType lookupComponentErrorType(ComponentIdentifier componentIdentifier, Class<? extends Throwable> exception) {
        ExceptionMapper exceptionMapper = this.componentExceptionMappers.get(componentIdentifier);
        Optional<ErrorType> errorType = Optional.empty();
        if (exceptionMapper != null) {
            errorType = exceptionMapper.resolveErrorType(exception);
        }
        return errorType.orElseGet(() -> this.defaultExceptionMapper.resolveErrorType(exception).get());
    }

    public ErrorType lookupComponentErrorType(ComponentIdentifier componentIdentifier, Throwable exception) {
        return this.lookupComponentErrorType(componentIdentifier, exception.getClass());
    }

    public void addComponentExceptionMapper(ComponentIdentifier componentIdentifier, ExceptionMapper exceptionMapper) {
        this.componentExceptionMappers.put(componentIdentifier, exceptionMapper);
    }

    public static Builder builder(ErrorTypeRepository errorTypeRepository) {
        return new Builder(errorTypeRepository);
    }

    public static class Builder {
        private ExceptionMapper defaultExceptionMapper;
        private Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers = new HashedMap();

        public Builder(ErrorTypeRepository errorTypeRepository) {
            Preconditions.checkArgument((errorTypeRepository != null ? 1 : 0) != 0, (String)"error type repository cannot be null");
        }

        public Builder defaultExceptionMapper(ExceptionMapper exceptionMapper) {
            this.defaultExceptionMapper = exceptionMapper;
            return this;
        }

        public Builder addComponentExceptionMapper(ComponentIdentifier componentIdentifier, ExceptionMapper exceptionMapper) {
            this.componentExceptionMappers.put(componentIdentifier, exceptionMapper);
            return this;
        }

        public ErrorTypeLocator build() {
            Preconditions.checkState((this.defaultExceptionMapper != null ? 1 : 0) != 0, (String)"default exception mapper cannot not be null");
            Preconditions.checkState((this.componentExceptionMappers != null ? 1 : 0) != 0, (String)"component exception mappers cannot not be null");
            return new ErrorTypeLocator(this.defaultExceptionMapper, this.componentExceptionMappers);
        }
    }
}

