/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.GlobalNameableObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.security.SecurityException;
import org.mule.runtime.core.config.ExceptionHelper;
import org.mule.runtime.core.context.notification.ExceptionNotification;
import org.mule.runtime.core.context.notification.SecurityNotification;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.MessagingExceptionHandlerToSystemAdapter;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.management.stats.ServiceStatistics;
import org.mule.runtime.core.message.ExceptionMessage;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.routing.filters.WildcardFilter;
import org.mule.runtime.core.routing.outbound.MulticastingRouter;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.core.util.NotificationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionListener
extends AbstractMessageProcessorOwner
implements GlobalNameableObject {
    protected static final String NOT_SET = "<not set>";
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<Processor> messageProcessors = new CopyOnWriteArrayList<Processor>();
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected WildcardFilter rollbackTxFilter;
    protected WildcardFilter commitTxFilter;
    protected boolean enableNotifications = true;
    protected String logException = "true";
    protected String globalName;

    @Override
    public String getGlobalName() {
        return this.globalName;
    }

    @Override
    public void setGlobalName(String globalName) {
        this.globalName = globalName;
    }

    public AbstractExceptionListener() {
        super.setMessagingExceptionHandler(new MessagingExceptionHandlerToSystemAdapter(this.muleContext));
    }

    protected boolean isRollback(Throwable t) {
        t = ExceptionHelper.getRootException((Throwable)t);
        if (this.rollbackTxFilter == null && this.commitTxFilter == null) {
            return true;
        }
        return this.rollbackTxFilter != null && this.rollbackTxFilter.accept(t.getClass().getName()) || this.commitTxFilter != null && !this.commitTxFilter.accept(t.getClass().getName());
    }

    public List<Processor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(List<Processor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    public void addEndpoint(Processor processor) {
        if (processor != null) {
            this.messageProcessors.add(processor);
        }
    }

    public boolean removeMessageProcessor(Processor processor) {
        return this.messageProcessors.remove(processor);
    }

    protected Throwable getExceptionType(Throwable t, Class<? extends Throwable> exceptionType) {
        while (t != null) {
            if (exceptionType.isAssignableFrom(t.getClass())) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            super.initialise();
            this.doInitialise(this.muleContext);
            this.initialised.set(true);
        }
    }

    protected void doInitialise(MuleContext context) throws InitialisationException {
        this.logger.info("Initialising exception listener: " + this.toString());
    }

    protected void fireNotification(Exception ex) {
        if (this.enableNotifications) {
            if (ex.getCause() != null && ex.getCause() instanceof SecurityException) {
                this.fireNotification(new SecurityNotification((SecurityException)((Object)ex.getCause()), 401));
            } else {
                this.fireNotification(new ExceptionNotification(ex));
            }
        }
    }

    protected Event routeException(Event event, FlowConstruct flowConstruct, Throwable t) {
        Event result = event;
        if (!this.messageProcessors.isEmpty()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Message being processed is: " + this.muleContext.getTransformationService().getPayloadForLogging(event.getMessage()));
                }
                ExceptionMessage msg = new ExceptionMessage(event, t, flowConstruct.getName(), event.getContext().getOriginatingConnectorName());
                InternalMessage exceptionMessage = InternalMessage.builder(event.getMessage()).payload(msg).build();
                MulticastingRouter router = this.buildRouter();
                router.setRoutes(this.getMessageProcessors());
                router.setMuleContext(this.muleContext);
                result = router.route(Event.builder(event).message(exceptionMessage).build());
            }
            catch (Exception e) {
                this.logFatal(event, e);
            }
        }
        this.processOutboundRouterStatistics();
        return result;
    }

    protected MulticastingRouter buildRouter() {
        MulticastingRouter router = new MulticastingRouter();
        return router;
    }

    protected void closeStream(InternalMessage message) {
        if (this.muleContext == null || this.muleContext.isDisposing() || this.muleContext.isDisposed()) {
            return;
        }
        if (message != null) {
            this.muleContext.getStreamCloserService().closeStream(message.getPayload().getValue());
        }
    }

    protected void logException(Throwable t, Event event) {
        if (this.muleContext.getExpressionManager().evaluateBoolean(this.logException, event, this.flowConstruct, true, true)) {
            this.doLogException(t);
        }
    }

    protected void doLogException(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)t);
        if (muleException != null) {
            this.logger.error(muleException.getDetailedMessage());
        } else {
            this.logger.error("Caught exception in Exception Strategy: " + t.getMessage(), t);
        }
    }

    protected void logFatal(Event event, Throwable t) {
        FlowConstructStatistics statistics = this.flowConstruct.getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incFatalError();
        }
        String logUniqueId = StringUtils.defaultString((String)event.getCorrelationId(), (String)NOT_SET);
        String printableLogMessage = MessageFormat.format("Message identification summary here: id={0}, correlation={1}", logUniqueId, event.getGroupCorrelation());
        this.logger.error("Failed to dispatch message to error queue after it failed to process.  This may cause message loss. " + (event.getMessage() == null ? "" : printableLogMessage), t);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    protected void fireNotification(ServerNotification notification) {
        if (this.muleContext != null) {
            this.muleContext.fireNotification(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug("MuleContext is not yet available for firing notifications, ignoring event: " + notification);
        }
    }

    public WildcardFilter getCommitTxFilter() {
        return this.commitTxFilter;
    }

    public void setCommitTxFilter(WildcardFilter commitTxFilter) {
        this.commitTxFilter = commitTxFilter;
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public String isLogException() {
        return this.logException;
    }

    public void setLogException(String logException) {
        this.logException = logException;
    }

    public WildcardFilter getRollbackTxFilter() {
        return this.rollbackTxFilter;
    }

    public void setRollbackTxFilter(WildcardFilter rollbackTxFilter) {
        this.rollbackTxFilter = rollbackTxFilter;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
    }

    protected void commit() {
        TransactionCoordination.getInstance().commitCurrentTransaction();
    }

    protected void rollback(Exception ex) {
        if (TransactionCoordination.getInstance().getTransaction() != null) {
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        }
        if (ex instanceof MessagingException) {
            MessagingException messagingException = (MessagingException)((Object)ex);
            messagingException.setCauseRollback(true);
        }
    }

    void processOutboundRouterStatistics() {
        List<Processor> processors = this.getMessageProcessors();
        FlowConstructStatistics statistics = this.flowConstruct.getStatistics();
        if (CollectionUtils.isNotEmpty(processors) && statistics instanceof ServiceStatistics && statistics.isEnabled()) {
            for (Processor endpoint : processors) {
                ((ServiceStatistics)statistics).getOutboundRouterStat().incrementRoutedMessage(endpoint);
            }
        }
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        NotificationUtils.addMessageProcessorPathElements(this.messageProcessors, pathElement);
    }
}

