/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.enricher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.metadata.DefaultTypedValue;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.util.NotificationUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.rx.Exceptions;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageEnricher
extends AbstractMessageProcessorOwner
implements Processor {
    private List<EnrichExpressionPair> enrichExpressionPairs = new ArrayList<EnrichExpressionPair>();
    private Processor enrichmentProcessor;

    @Override
    public Event process(Event event) throws MuleException {
        return this.enrich(this.enrichmentProcessor.process(Event.builder(event).session(new DefaultMuleSession(event.getSession())).build()), event);
    }

    protected Event enrich(Event currentEvent, Event enrichmentEvent, String sourceExpressionArg, String targetExpressionArg, ExtendedExpressionManager expressionManager) {
        DefaultTypedValue<Object> typedValue;
        if (StringUtils.isEmpty((String)sourceExpressionArg)) {
            sourceExpressionArg = "#[payload:]";
        }
        if ((typedValue = expressionManager.evaluate(sourceExpressionArg, enrichmentEvent, this.flowConstruct)).getValue() instanceof InternalMessage) {
            InternalMessage muleMessage = (InternalMessage)typedValue.getValue();
            typedValue = new DefaultTypedValue<Object>(muleMessage.getPayload().getValue(), muleMessage.getPayload().getDataType());
        }
        if (!StringUtils.isEmpty((String)targetExpressionArg)) {
            Event.Builder eventBuilder = Event.builder(currentEvent);
            expressionManager.enrich(targetExpressionArg, currentEvent, eventBuilder, this.flowConstruct, typedValue);
            return eventBuilder.build();
        }
        return Event.builder(currentEvent).message(InternalMessage.builder(currentEvent.getMessage()).payload(typedValue.getValue()).mediaType(typedValue.getDataType().getMediaType()).build()).build();
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).flatMap(event -> Mono.just((Object)event).map(event1 -> Event.builder(event).session(new DefaultMuleSession(event.getSession())).build()).transform((Function)this.enrichmentProcessor).map(Exceptions.checkedFunction(response -> this.enrich((Event)response, (Event)event))).otherwiseIfEmpty(Mono.just((Object)event)));
    }

    protected Event enrich(Event event, Event eventToEnrich) throws MuleException {
        ExtendedExpressionManager expressionManager = this.muleContext.getExpressionManager();
        if (event != null) {
            for (EnrichExpressionPair pair : this.enrichExpressionPairs) {
                eventToEnrich = this.enrich(eventToEnrich, event, pair.getSource(), pair.getTarget(), expressionManager);
            }
        }
        Event.setCurrentEvent(eventToEnrich);
        return eventToEnrich;
    }

    public void setEnrichmentMessageProcessor(Processor enrichmentProcessor) {
        this.enrichmentProcessor = MessageProcessors.newChain(enrichmentProcessor);
        LifecycleUtils.setMuleContextIfNeeded(this.enrichmentProcessor, this.muleContext);
    }

    public void setMessageProcessor(Processor enrichmentProcessor) {
        this.setEnrichmentMessageProcessor(enrichmentProcessor);
    }

    public void setEnrichExpressionPairs(List<EnrichExpressionPair> enrichExpressionPairs) {
        this.enrichExpressionPairs = enrichExpressionPairs;
    }

    public void addEnrichExpressionPair(EnrichExpressionPair pair) {
        this.enrichExpressionPairs.add(pair);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.enrichmentProcessor);
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        NotificationUtils.addMessageProcessorPathElements(this.enrichmentProcessor, pathElement.addChild(this));
    }

    public static class EnrichExpressionPair {
        private String source;
        private String target;

        public EnrichExpressionPair() {
        }

        public EnrichExpressionPair(String target) {
            this.target = target;
        }

        public EnrichExpressionPair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }
}

