/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.v2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionExecutor;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguage;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.metadata.DefaultTypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleExpressionLanguage
implements ExtendedExpressionLanguage {
    private static final Logger logger = LoggerFactory.getLogger(MuleExpressionLanguage.class);
    public static final String ATTRIBUTES = "attributes";
    public static final String PAYLOAD = "payload";
    public static final String ERROR = "error";
    public static final String VARIABLES = "variables";
    public static final String FLOW = "flow";
    private ExpressionExecutor expressionExecutor;
    private BindingContext globalBindingContext;

    public MuleExpressionLanguage(ClassLoader lookupClassloader) {
        Iterator<ExpressionExecutor> executors = ServiceLoader.load(ExpressionExecutor.class, lookupClassloader).iterator();
        if (executors.hasNext()) {
            try {
                this.expressionExecutor = executors.next();
            }
            catch (Throwable e) {
                logger.warn("DW Executor could not be loaded.");
            }
        }
        this.globalBindingContext = BindingContext.builder().build();
    }

    @Override
    public TypedValue evaluate(String expression, Event event, BindingContext context) {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        return this.evaluate(expression, contextBuilder.build());
    }

    @Override
    public TypedValue evaluate(String expression, Event event, FlowConstruct flowConstruct, BindingContext bindingContext) {
        return this.evaluate(expression, event, null, flowConstruct, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, BindingContext context) {
        BindingContext.Builder contextBuilder = this.bindingContextBuilderFor(event, context);
        this.addFlowBindings(flowConstruct, contextBuilder);
        return this.evaluate(expression, contextBuilder.build());
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.expressionExecutor.validate(this.sanitize(expression));
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, Object object) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    @Override
    public void enrich(String expression, Event event, Event.Builder eventBuilder, FlowConstruct flowConstruct, TypedValue value) {
        throw new UnsupportedOperationException("Enrichment is not allowed, yet.");
    }

    private TypedValue evaluate(String expression, BindingContext context) {
        try {
            return this.expressionExecutor.evaluate(this.sanitize(expression), context);
        }
        catch (ExpressionExecutionException e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(expression), e);
        }
    }

    private BindingContext.Builder addFlowBindings(FlowConstruct flow, BindingContext.Builder contextBuilder) {
        if (flow != null) {
            contextBuilder.addBinding(FLOW, new DefaultTypedValue<FlowVariablesAccessor>(new FlowVariablesAccessor(flow.getName()), DataType.fromType(FlowVariablesAccessor.class)));
        }
        return contextBuilder;
    }

    private void addEventBindings(Event event, BindingContext.Builder contextBuilder) {
        if (event != null) {
            HashMap flowVars = new HashMap();
            event.getVariableNames().forEach(name -> {
                TypedValue value = event.getVariable((String)name);
                flowVars.put(name, value);
                contextBuilder.addBinding(name, value);
            });
            contextBuilder.addBinding(VARIABLES, new DefaultTypedValue(Collections.unmodifiableMap(flowVars), DataType.fromType(flowVars.getClass())));
            InternalMessage message = event.getMessage();
            Attributes attributes = message.getAttributes();
            contextBuilder.addBinding(ATTRIBUTES, new DefaultTypedValue<Attributes>(attributes, DataType.fromType(attributes.getClass())));
            contextBuilder.addBinding(PAYLOAD, message.getPayload());
            Error error = event.getError().isPresent() ? (Error)event.getError().get() : null;
            contextBuilder.addBinding(ERROR, new DefaultTypedValue<Error>(error, DataType.fromType(Error.class)));
        }
    }

    private BindingContext.Builder bindingContextBuilderFor(Event event, BindingContext context) {
        BindingContext.Builder contextBuilder = BindingContext.builder((BindingContext)context);
        this.addEventBindings(event, contextBuilder);
        return contextBuilder;
    }

    private String sanitize(String expression) {
        String sanitizedExpression;
        String string = sanitizedExpression = expression.startsWith("#[") ? expression.substring("#[".length(), expression.length() - "]".length()) : expression;
        if (sanitizedExpression.startsWith("dw:")) {
            sanitizedExpression = sanitizedExpression.substring("dw:".length());
        }
        return sanitizedExpression;
    }

    private class FlowVariablesAccessor {
        private String name;

        public FlowVariablesAccessor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

