/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.el.context.FlowVariableMapContext;
import org.mule.runtime.core.el.context.MessageContext;
import org.mule.runtime.core.el.context.ModuleOperationVariableMapContext;
import org.mule.runtime.core.el.context.SessionVariableMapContext;
import org.mule.runtime.core.el.mvel.MuleBaseVariableResolverFactory;
import org.mule.runtime.core.el.mvel.MuleImmutableVariableResolver;
import org.mule.runtime.core.el.mvel.MuleVariableResolver;
import org.mule.runtime.core.exception.MessagingException;

public class MessageVariableResolverFactory
extends MuleBaseVariableResolverFactory {
    private static final long serialVersionUID = -6819292692339684915L;
    private static final String MESSAGE = "message";
    private static final String EXCEPTION = "exception";
    private static final String ERROR = "error";
    public static final String PAYLOAD = "payload";
    public static final String MESSAGE_PAYLOAD = "message.payload";
    public static final String FLOW_VARS = "flowVars";
    public static final String SESSION_VARS = "sessionVars";
    public static final String PARAM_VARS = "param";
    public static final String PROPERTY_VARS = "property";
    protected Event event;
    protected Event.Builder eventBuilder;
    protected MuleContext muleContext;

    public MessageVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, Event event, Event.Builder eventBuilder) {
        this.event = event;
        this.eventBuilder = eventBuilder;
        this.muleContext = muleContext;
    }

    public MessageVariableResolverFactory(ParserConfiguration parserConfiguration, MuleContext muleContext, Event event, Event.Builder eventBuilder, VariableResolverFactory next) {
        this(parserConfiguration, muleContext, event, eventBuilder);
        this.setNextFactory(next);
    }

    @Override
    public boolean isTarget(String name) {
        return MESSAGE.equals(name) || PAYLOAD.equals(name) || FLOW_VARS.equals(name) || EXCEPTION.equals(name) || ERROR.equals(name) || SESSION_VARS.equals(name) || "_muleMessage".equals(name) || PARAM_VARS.equals(name) || PROPERTY_VARS.equals(name);
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        if (this.event != null) {
            if (MESSAGE.equals(name)) {
                return new MuleImmutableVariableResolver<MessageContext>(MESSAGE, new MessageContext(this.event, this.eventBuilder, this.muleContext), null);
            }
            if (PAYLOAD.equals(name)) {
                return new MuleVariableResolver<Object>(PAYLOAD, new MessageContext(this.event, this.eventBuilder, this.muleContext).getPayload(), null, (name1, value, newValue) -> this.eventBuilder.message(InternalMessage.builder(this.event.getMessage()).payload(newValue).build()));
            }
            if (FLOW_VARS.equals(name)) {
                return new MuleImmutableVariableResolver<FlowVariableMapContext>(FLOW_VARS, new FlowVariableMapContext(this.event, this.eventBuilder), null);
            }
            if (EXCEPTION.equals(name)) {
                if (this.event.getError().isPresent()) {
                    Throwable exception = ((Error)this.event.getError().get()).getCause();
                    return new MuleImmutableVariableResolver<MessagingException>(EXCEPTION, this.wrapIfNecessary(this.event, exception), null);
                }
                if (this.event.getMessage().getExceptionPayload() != null) {
                    Throwable exception = this.event.getMessage().getExceptionPayload().getException();
                    return new MuleImmutableVariableResolver<MessagingException>(EXCEPTION, this.wrapIfNecessary(this.event, exception), null);
                }
                return new MuleImmutableVariableResolver<Object>(EXCEPTION, null, null);
            }
            if (ERROR.equals(name)) {
                if (this.event.getError().isPresent()) {
                    return new MuleImmutableVariableResolver(ERROR, this.event.getError().get(), null);
                }
                return new MuleImmutableVariableResolver<Object>(ERROR, null, null);
            }
            if (SESSION_VARS.equals(name)) {
                return new MuleImmutableVariableResolver<SessionVariableMapContext>(SESSION_VARS, new SessionVariableMapContext(this.event.getSession()), null);
            }
            if ("_muleMessage".equals(name)) {
                return new MuleImmutableVariableResolver<InternalMessage>("_muleMessage", this.event.getMessage(), null);
            }
            if (PARAM_VARS.equals(name) || PROPERTY_VARS.equals(name)) {
                return new MuleImmutableVariableResolver<ModuleOperationVariableMapContext>(FLOW_VARS, new ModuleOperationVariableMapContext(this.event, this.eventBuilder, name), null);
            }
        }
        return super.getNextFactoryVariableResolver(name);
    }

    private MessagingException wrapIfNecessary(Event event, Throwable exception) {
        if (exception instanceof MessagingException) {
            return (MessagingException)((Object)exception);
        }
        return new MessagingException(event, exception);
    }
}

