/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.mvel;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.el.ExpressionExecutor;
import org.mule.runtime.core.api.expression.InvalidExpressionException;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELExpressionExecutor
implements ExpressionExecutor<MVELExpressionLanguageContext> {
    private static Logger log = LoggerFactory.getLogger(MVELExpressionExecutor.class);
    protected static final String DISABLE_MEL_EXPRESSION_CACHE = "mule.disableMelExpressionCache";
    protected static final int COMPILED_EXPRESSION_MAX_CACHE_SIZE = 1000;
    protected ParserConfiguration parserConfiguration;
    protected LoadingCache<String, Serializable> compiledExpressionsCache;

    public MVELExpressionExecutor(final ParserConfiguration parserConfiguration) {
        this.parserConfiguration = parserConfiguration;
        MVEL.COMPILER_OPT_PROPERTY_ACCESS_DOESNT_FAIL = true;
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        this.compiledExpressionsCache = CacheBuilder.newBuilder().maximumSize((long)this.getCompiledExpressionMaxCacheSize()).build((CacheLoader)new CacheLoader<String, Serializable>(){

            public Serializable load(String key) throws Exception {
                return MVEL.compileExpression((String)key, (ParserContext)new ParserContext(parserConfiguration));
            }
        });
    }

    private int getCompiledExpressionMaxCacheSize() {
        String propertyValue = System.getProperty(DISABLE_MEL_EXPRESSION_CACHE);
        if (propertyValue != null) {
            return 0;
        }
        return 1000;
    }

    @Override
    public Object execute(String expression, MVELExpressionLanguageContext context) {
        if (log.isTraceEnabled()) {
            log.trace("Executing MVEL expression '" + expression + "' with context: \n" + context.toString());
        }
        return MVEL.executeExpression((Object)this.getCompiledExpression(expression), (VariableResolverFactory)context);
    }

    @Override
    public void validate(String expression) throws InvalidExpressionException {
        this.getCompiledExpression(expression);
    }

    public Serializable getCompiledExpression(String expression) {
        try {
            return (Serializable)this.compiledExpressionsCache.getUnchecked((Object)expression);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

