/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.el.context.AbstractMapContext;

public class ModuleOperationVariableMapContext
extends AbstractMapContext<Object> {
    private Event event;
    private Event.Builder eventBuider;
    private String prefix;

    public ModuleOperationVariableMapContext(Event event, Event.Builder eventBuider, String prefix) {
        this.event = event;
        this.eventBuider = eventBuider;
        this.prefix = prefix;
    }

    @Override
    public Object doGet(String key) {
        return Event.getVariableValueOrNull(this.applyPrefix(key), this.event);
    }

    @Override
    public void doPut(String key, Object value) {
        this.eventBuider.addVariable(this.applyPrefix(key), value);
        this.event = this.eventBuider.build();
    }

    @Override
    public void doRemove(String key) {
        this.eventBuider.removeVariable(this.applyPrefix(key));
        this.event = this.eventBuider.build();
    }

    @Override
    public Set<String> keySet() {
        return this.event.getVariableNames();
    }

    @Override
    public void clear() {
        this.eventBuider.variables(Collections.emptyMap());
        this.event = this.eventBuider.build();
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.event.getVariableNames()) {
            String keyWithPrefix = this.applyPrefix(key);
            Object value = this.event.getVariable(keyWithPrefix) != null ? this.event.getVariable(keyWithPrefix).getValue() : null;
            map.put(keyWithPrefix, value);
        }
        return ((Object)map).toString();
    }

    private String applyPrefix(String key) {
        return this.prefix + "." + key;
    }
}

