/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.io.IOException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.IOUtils;

public class ExpressionLanguageComponent
extends AbstractAnnotatedObject
implements Processor,
MuleContextAware,
FlowConstructAware,
Initialisable {
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected String expression;
    protected String expressionFile;

    public void initialise() throws InitialisationException {
        if (this.expressionFile != null) {
            try {
                this.expression = IOUtils.getResourceAsString(this.expressionFile, this.getClass());
            }
            catch (IOException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        } else if (this.expression == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("expression"), (Initialisable)this);
        }
    }

    @Override
    public Event process(Event event) throws MuleException {
        Event.Builder eventBuilder = Event.builder(event);
        this.muleContext.getExpressionManager().evaluate(this.expression, event, eventBuilder, this.flowConstruct);
        return eventBuilder.build();
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setExpressionFile(String expressionFile) {
        this.expressionFile = expressionFile;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

