/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import org.mule.runtime.api.meta.NameableObject;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.MessageProcessorPathResolver;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.context.notification.SynchronousServerEvent;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.ObjectUtils;

public class MessageProcessorNotification
extends ServerNotification
implements SynchronousServerEvent {
    private static final long serialVersionUID = 1L;
    public static final int MESSAGE_PROCESSOR_PRE_INVOKE = 1601;
    public static final int MESSAGE_PROCESSOR_POST_INVOKE = 1602;
    private final transient Processor processor;
    private final transient FlowConstruct flowConstruct;
    private final String processorPath;
    private static ThreadLocal<String> lastRootMessageId;
    private MessagingException exceptionThrown;

    public MessageProcessorNotification(FlowConstruct flowConstruct, Event event, Processor processor, MessagingException exceptionThrown, int action) {
        super(MessageProcessorNotification.produceEvent(event, flowConstruct), action, flowConstruct.getName());
        this.exceptionThrown = exceptionThrown;
        this.processor = processor;
        this.processorPath = flowConstruct instanceof MessageProcessorPathResolver ? ((MessageProcessorPathResolver)((Object)flowConstruct)).getProcessorPath(processor) : null;
        this.flowConstruct = flowConstruct;
    }

    @Override
    public Event getSource() {
        if (this.source instanceof String) {
            return null;
        }
        return (Event)super.getSource();
    }

    public Processor getProcessor() {
        return this.processor;
    }

    protected String processorToString() {
        if (this.processor == null) {
            return "";
        }
        String name = this.processor instanceof NameableObject ? String.format("%s '%s'", this.processor.getClass().getName(), ((NameableObject)this.processor).getName()) : ObjectUtils.identityToString((Object)this.processor);
        return name;
    }

    private static Event produceEvent(Event sourceEvent, FlowConstruct flowConstruct) {
        String rootId = lastRootMessageId.get();
        if (sourceEvent != null) {
            lastRootMessageId.set(sourceEvent.getCorrelationId());
            return sourceEvent;
        }
        if (rootId != null && flowConstruct != null) {
            InternalMessage msg = InternalMessage.builder().nullPayload().build();
            return Event.builder(DefaultEventContext.create(flowConstruct, "MessageProcessorNotification", lastRootMessageId.get())).message(msg).flow(flowConstruct).exchangePattern(MessageExchangePattern.REQUEST_RESPONSE).build();
        }
        return null;
    }

    public MessagingException getExceptionThrown() {
        return this.exceptionThrown;
    }

    public String getProcessorPath() {
        return this.processorPath;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + MessageProcessorNotification.getActionName(this.action) + ", processor=" + this.processorPath + ", resourceId=" + this.resourceIdentifier + ", serverId=" + this.serverId + ", timestamp=" + this.timestamp + "}";
    }

    static {
        MessageProcessorNotification.registerAction("message processor pre invoke", 1601);
        MessageProcessorNotification.registerAction("message processor post invoke", 1602);
        lastRootMessageId = new ThreadLocal();
    }
}

