/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContext;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.CoreEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.execution.LocationExecutionContextProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.DefaultMuleConfiguration;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.context.notification.DefaultProcessorsTrace;
import org.mule.runtime.core.context.notification.FlowNotificationTextDebugger;
import org.mule.runtime.core.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.context.notification.MessageProcessorTextDebugger;
import org.mule.runtime.core.context.notification.PipelineMessageNotification;
import org.mule.runtime.core.logging.LogConfigChangeSubject;

public class MessageProcessingFlowTraceManager
extends LocationExecutionContextProvider
implements FlowTraceManager,
MuleContextAware,
Initialisable,
Disposable {
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    private final FlowNotificationTextDebugger pipelineProcessorDebugger;
    private final MessageProcessorTextDebugger messageProcessorTextDebugger;
    private MuleContext muleContext;
    private PropertyChangeListener logConfigChangeListener = evt -> this.handleNotificationListeners();

    public MessageProcessingFlowTraceManager() {
        this.messageProcessorTextDebugger = new MessageProcessorTextDebugger(this);
        this.pipelineProcessorDebugger = new FlowNotificationTextDebugger(this);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).registerLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.handleNotificationListeners();
    }

    public void dispose() {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).unregisterLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.removeNotificationListeners();
    }

    protected void handleNotificationListeners() {
        if (DefaultMuleConfiguration.isFlowTrace()) {
            this.muleContext.getNotificationManager().addListener(this.messageProcessorTextDebugger);
            this.muleContext.getNotificationManager().addListener(this.pipelineProcessorDebugger);
        } else {
            this.removeNotificationListeners();
        }
    }

    protected void removeNotificationListeners() {
        this.muleContext.getNotificationManager().removeListener(this.messageProcessorTextDebugger);
        this.muleContext.getNotificationManager().removeListener(this.pipelineProcessorDebugger);
    }

    public void onMessageProcessorNotificationPreInvoke(MessageProcessorNotification notification) {
        String resolveProcessorRepresentation = MessageProcessingFlowTraceManager.resolveProcessorRepresentation((String)this.muleContext.getConfiguration().getId(), (String)notification.getProcessorPath(), (Object)notification.getProcessor());
        if (((CoreEventContext)notification.getSource().getContext()).getProcessorsTrace() instanceof DefaultProcessorsTrace) {
            ((DefaultProcessorsTrace)((CoreEventContext)notification.getSource().getContext()).getProcessorsTrace()).addExecutedProcessors(resolveProcessorRepresentation);
        }
        if (notification.getSource().getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)notification.getSource().getFlowCallStack()).setCurrentProcessorPath(resolveProcessorRepresentation);
        }
    }

    public void onPipelineNotificationComplete(PipelineMessageNotification notification) {
        this.onFlowComplete((Event)notification.getSource());
    }

    public void onPipelineNotificationStart(PipelineMessageNotification notification) {
        this.onFlowStart((Event)notification.getSource(), notification.getResourceIdentifier());
    }

    @Override
    public void onFlowStart(Event muleEvent, String flowName) {
        if (muleEvent.getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)muleEvent.getFlowCallStack()).push(new FlowStackElement(flowName, null));
        }
    }

    @Override
    public void onFlowComplete(Event muleEvent) {
        if (muleEvent.getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)muleEvent.getFlowCallStack()).pop();
        }
    }

    @Override
    public Map<String, Object> getContextInfo(Event muleEvent, Processor lastProcessed, FlowConstruct flowConstruct) {
        if (DefaultMuleConfiguration.isFlowTrace()) {
            return Collections.singletonMap(FLOW_STACK_INFO_KEY, muleEvent.getFlowCallStack().toString());
        }
        return Collections.emptyMap();
    }
}

