/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.context.notification;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.mule.runtime.core.api.context.notification.ServerNotification;

public class ExceptionNotification
extends ServerNotification {
    private static final long serialVersionUID = -43091546451476239L;
    public static final int EXCEPTION_ACTION = 1101;
    private Throwable exception;

    public ExceptionNotification(Throwable exception) {
        super(exception, 1101, ExceptionNotification.getExceptionCause(exception));
        this.exception = exception;
    }

    private static String getExceptionCause(Throwable exception) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)exception);
        if (cause != null) {
            return cause.getClass().getName();
        }
        return null;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String getType() {
        return "error";
    }

    static {
        ExceptionNotification.registerAction("exception", 1101);
    }
}

