/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.construct.builder;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.construct.AbstractFlowConstruct;

public abstract class AbstractFlowConstructBuilder<T extends AbstractFlowConstructBuilder<?, ?>, F extends AbstractFlowConstruct> {
    protected String name;
    protected String initialState;
    protected MessageSource messageSource;
    protected MessagingExceptionHandler exceptionListener;
    protected List<Processor> transformers = Collections.emptyList();
    protected List<Processor> responseTransformers = Collections.emptyList();

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T messageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        return (T)this;
    }

    public T exceptionStrategy(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
        return (T)this;
    }

    public T initialState(String initialState) {
        this.initialState = initialState;
        return (T)this;
    }

    public F build(MuleContext muleContext) throws MuleException {
        F flowConstruct = this.buildFlowConstruct(muleContext);
        this.addExceptionListener((AbstractFlowConstruct)flowConstruct);
        if (this.initialState != null) {
            ((AbstractFlowConstruct)flowConstruct).setInitialState(this.initialState);
        }
        return flowConstruct;
    }

    public F buildAndRegister(MuleContext muleContext) throws MuleException {
        F flowConstruct = this.build(muleContext);
        muleContext.getRegistry().registerObject(((AbstractFlowConstruct)flowConstruct).getName(), flowConstruct);
        return flowConstruct;
    }

    protected abstract F buildFlowConstruct(MuleContext var1) throws MuleException;

    protected void addExceptionListener(AbstractFlowConstruct flowConstruct) {
        if (this.exceptionListener != null) {
            flowConstruct.setExceptionListener(this.exceptionListener);
        } else {
            flowConstruct.setExceptionListener(flowConstruct.getMuleContext().getDefaultErrorHandler());
        }
    }
}

