/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.construct;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.context.notification.FlowConstructNotification;
import org.mule.runtime.core.lifecycle.SimpleLifecycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowConstructLifecycleManager
extends SimpleLifecycleManager<FlowConstruct> {
    protected final transient Logger logger = LoggerFactory.getLogger(FlowConstructLifecycleManager.class);
    protected MuleContext muleContext;

    public FlowConstructLifecycleManager(FlowConstruct flowConstruct, MuleContext muleContext) {
        super(flowConstruct.getName(), flowConstruct);
        this.muleContext = muleContext;
    }

    @Override
    protected void registerTransitions() {
        super.registerTransitions();
        this.addDirectTransition("start", "pause");
        this.addDirectTransition("pause", "resume");
        this.addDirectTransition("pause", "stop");
    }

    @Override
    protected void notifyTransition(String currentPhase) {
        if (currentPhase.equals("resume")) {
            this.completedPhases.remove("resume");
            this.completedPhases.remove("pause");
            this.setCurrentPhase("start");
        }
    }

    @Override
    public void fireInitialisePhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("initialise");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initialising flow: " + ((FlowConstruct)this.getLifecycleObject()).getName());
        }
        this.invokePhase("initialise", this.getLifecycleObject(), callback);
        this.fireNotification(1501);
    }

    @Override
    public void fireStartPhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("start");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Starting flow: " + ((FlowConstruct)this.getLifecycleObject()).getName());
        }
        this.invokePhase("start", this.getLifecycleObject(), callback);
        this.fireNotification(1502);
    }

    public void firePausePhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("pause");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Pausing flow: " + ((FlowConstruct)this.getLifecycleObject()).getName());
        }
        this.invokePhase("pause", this.getLifecycleObject(), callback);
        this.fireNotification(1504);
    }

    public void fireResumePhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("resume");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Resuming flow: " + ((FlowConstruct)this.getLifecycleObject()).getName());
        }
        this.invokePhase("resume", this.getLifecycleObject(), callback);
        this.fireNotification(1505);
    }

    @Override
    public void fireStopPhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("stop");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stopping flow: " + ((FlowConstruct)this.getLifecycleObject()).getName());
        }
        this.invokePhase("stop", this.getLifecycleObject(), callback);
        this.fireNotification(1503);
    }

    @Override
    public void fireDisposePhase(LifecycleCallback<FlowConstruct> callback) throws MuleException {
        this.checkPhase("dispose");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Disposing flow: " + ((FlowConstruct)this.getLifecycleObject()).getName());
        }
        this.invokePhase("dispose", this.getLifecycleObject(), callback);
        this.fireNotification(1506);
    }

    protected void fireNotification(int action) {
        this.muleContext.fireNotification(new FlowConstructNotification((FlowConstruct)this.getLifecycleObject(), action));
    }
}

