/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.construct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.DynamicPipeline;
import org.mule.runtime.core.api.processor.DynamicPipelineBuilder;
import org.mule.runtime.core.api.processor.DynamicPipelineException;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.InternalMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.UUID;
import org.reactivestreams.Publisher;

public class DynamicPipelineMessageProcessor
extends AbstractInterceptingMessageProcessor
implements DynamicPipeline,
InternalMessageProcessor {
    private String pipelineId;
    private MessageProcessorChain preChain;
    private MessageProcessorChain postChain;
    private Processor staticChain;
    private Flow flow;

    public DynamicPipelineMessageProcessor(Flow flow) {
        this.flow = flow;
    }

    @Override
    public Event process(Event event) throws MuleException {
        return this.processNext(event);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return this.applyNext(publisher);
    }

    @Override
    public void setListener(Processor next) {
        if (this.staticChain == null) {
            this.staticChain = next instanceof InterceptingMessageProcessor ? event -> next.process(event) : next;
        }
        super.setListener(next);
    }

    private String resetAndUpdatePipeline(String id, List<Processor> preMessageProcessors, List<Processor> postMessageProcessors) throws MuleException {
        this.checkPipelineId(id);
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(preMessageProcessors);
        builder.chain(this.staticChain);
        builder.chain(postMessageProcessors);
        MessageProcessorChain newChain = builder.build();
        newChain.setFlowConstruct(this.flowConstruct);
        newChain.setMuleContext(this.muleContext);
        MessageProcessorChain preChainOld = this.preChain;
        MessageProcessorChain postChainOld = this.postChain;
        this.preChain = MessageProcessors.newChain(preMessageProcessors);
        this.postChain = MessageProcessors.newChain(postMessageProcessors);
        this.initDynamicChains();
        super.setListener(newChain);
        this.disposeDynamicChains(preChainOld, postChainOld);
        return this.getPipelineId();
    }

    private synchronized void checkPipelineId(String id) throws DynamicPipelineException {
        if (this.pipelineId != null) {
            if (!StringUtils.equals((String)this.pipelineId, (String)id)) {
                throw new DynamicPipelineException(CoreMessages.createStaticMessage((String)"Invalid Dynamic Pipeline ID"));
            }
        } else {
            this.pipelineId = id != null ? id : UUID.getUUID();
        }
    }

    private synchronized String getPipelineId() {
        return this.pipelineId;
    }

    private String resetPipeline(String id) throws MuleException {
        ArrayList<Processor> emptyList = new ArrayList<Processor>();
        return this.resetAndUpdatePipeline(id, emptyList, emptyList);
    }

    private void initDynamicChains() throws MuleException {
        for (Lifecycle chain : new Lifecycle[]{this.preChain, this.postChain}) {
            if (chain == null) continue;
            this.flow.injectFlowConstructMuleContext(chain);
            this.flow.injectExceptionHandler(chain);
            this.flow.initialiseIfInitialisable(chain);
            this.flow.startIfStartable(chain);
        }
    }

    private void disposeDynamicChains(Lifecycle ... chains) throws MuleException {
        for (Lifecycle chain : chains) {
            if (chain == null) continue;
            chain.stop();
            chain.dispose();
        }
    }

    @Override
    public DynamicPipelineBuilder dynamicPipeline(String id) throws DynamicPipelineException {
        this.checkPipelineId(id);
        return new Builder();
    }

    private class Builder
    implements DynamicPipelineBuilder {
        private List<Processor> preList = new ArrayList<Processor>();
        private List<Processor> postList = new ArrayList<Processor>();

        private Builder() {
        }

        @Override
        public DynamicPipelineBuilder injectBefore(Processor ... messageProcessors) {
            Collections.addAll(this.preList, messageProcessors);
            return this;
        }

        @Override
        public DynamicPipelineBuilder injectBefore(List<Processor> messageProcessors) {
            return this.injectBefore(messageProcessors.toArray(new Processor[messageProcessors.size()]));
        }

        @Override
        public DynamicPipelineBuilder injectAfter(Processor ... messageProcessors) {
            Collections.addAll(this.postList, messageProcessors);
            return this;
        }

        @Override
        public DynamicPipelineBuilder injectAfter(List<Processor> messageProcessors) {
            return this.injectAfter(messageProcessors.toArray(new Processor[messageProcessors.size()]));
        }

        @Override
        public String resetAndUpdate() throws MuleException {
            return this.pipeline().resetAndUpdatePipeline(this.pipeline().getPipelineId(), this.preList, this.postList);
        }

        @Override
        public String reset() throws MuleException {
            return this.pipeline().resetPipeline(this.pipeline().getPipelineId());
        }

        private DynamicPipelineMessageProcessor pipeline() {
            return DynamicPipelineMessageProcessor.this;
        }
    }
}

