/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.pool;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.config.ThreadingProfile;
import org.mule.runtime.core.config.pool.ThreadPoolFactory;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.core.util.concurrent.NamedThreadFactory;
import org.mule.runtime.core.util.concurrent.WaitPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThreadPoolFactory
extends ThreadPoolFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ThreadPoolExecutor createPool(String name, ThreadingProfile tp) {
        AbstractQueue buffer = tp.getMaxBufferSize() > 0 && tp.getMaxThreadsActive() > 1 ? new LinkedBlockingDeque(tp.getMaxBufferSize()) : new SynchronousQueue();
        ThreadPoolExecutor pool = this.internalCreatePool(name, tp, (BlockingQueue)((Object)buffer));
        this.configureThreadPoolExecutor(name, tp, pool);
        return pool;
    }

    private void configureThreadPoolExecutor(String name, ThreadingProfile tp, ThreadPoolExecutor pool) {
        this.configureThreadFactory(name, tp, pool);
        if (tp.getRejectedExecutionHandler() != null) {
            pool.setRejectedExecutionHandler(tp.getRejectedExecutionHandler());
        } else {
            switch (tp.getPoolExhaustedAction()) {
                case 2: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                    break;
                }
                case 4: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                    break;
                }
                case 3: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                    break;
                }
                case 1: {
                    pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                    break;
                }
                default: {
                    pool.setRejectedExecutionHandler(new WaitPolicy(tp.getThreadWaitTimeout(), TimeUnit.MILLISECONDS));
                }
            }
        }
    }

    @Override
    public ScheduledThreadPoolExecutor createScheduledPool(String name, ThreadingProfile tp) {
        ScheduledThreadPoolExecutor pool = this.internalCreateScheduledPool(tp);
        this.configureThreadPoolExecutor(name, tp, pool);
        return pool;
    }

    protected void configureThreadFactory(String name, ThreadingProfile tp, ThreadPoolExecutor pool) {
        if (tp.getThreadFactory() != null) {
            pool.setThreadFactory(tp.getThreadFactory());
        } else if (StringUtils.isNotBlank((String)name)) {
            pool.setThreadFactory(new NamedThreadFactory(name, Thread.currentThread().getContextClassLoader()));
        }
    }

    protected ThreadPoolExecutor internalCreatePool(String name, ThreadingProfile tp, BlockingQueue buffer) {
        return new ThreadPoolExecutor(Math.min(tp.getMaxThreadsIdle(), tp.getMaxThreadsActive()), tp.getMaxThreadsActive(), tp.getThreadTTL(), TimeUnit.MILLISECONDS, buffer);
    }

    protected ScheduledThreadPoolExecutor internalCreateScheduledPool(ThreadingProfile tp) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(tp.getMaxThreadsIdle());
        scheduledThreadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(true);
        scheduledThreadPoolExecutor.setKeepAliveTime(tp.getThreadTTL(), TimeUnit.MILLISECONDS);
        return scheduledThreadPoolExecutor;
    }
}

