/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config;

import java.io.Serializable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.api.store.QueueStore;
import org.mule.runtime.core.util.queue.DefaultQueueConfiguration;
import org.mule.runtime.core.util.queue.DelegateQueueManager;
import org.mule.runtime.core.util.queue.QueueManager;
import org.mule.runtime.core.util.queue.objectstore.QueueConfiguration;

public class QueueProfile {
    private int maxOutstandingMessages = 0;
    private QueueStore<Serializable> objectStore;

    public static QueueProfile newInstancePersistingToDefaultMemoryQueueStore(MuleContext muleContext) {
        return QueueProfile.newInstance("_defaultInMemoryQueueStore", muleContext);
    }

    public static QueueProfile newInstanceWithPersistentQueueStore(MuleContext muleContext) {
        return QueueProfile.newInstance("_defaultPersistentQueueStore", muleContext);
    }

    private static QueueProfile newInstance(String objectStoreKey, MuleContext muleContext) {
        QueueStore objectStore = (QueueStore)muleContext.getRegistry().lookupObject(objectStoreKey);
        return new QueueProfile(objectStore);
    }

    public QueueProfile(QueueStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public QueueProfile(QueueProfile queueProfile) {
        this.maxOutstandingMessages = queueProfile.getMaxOutstandingMessages();
        this.objectStore = queueProfile.objectStore;
    }

    public QueueProfile(int maxOutstandingMessages, QueueStore<Serializable> objectStore) {
        this.maxOutstandingMessages = maxOutstandingMessages;
        this.objectStore = objectStore;
    }

    public int getMaxOutstandingMessages() {
        return this.maxOutstandingMessages;
    }

    public void setMaxOutstandingMessages(int maxOutstandingMessages) {
        this.maxOutstandingMessages = maxOutstandingMessages;
    }

    public org.mule.runtime.core.util.queue.QueueConfiguration configureQueue(MuleContext context, String component, QueueManager queueManager) throws InitialisationException {
        org.mule.runtime.core.util.queue.QueueConfiguration qc = this.toQueueConfiguration(context);
        queueManager.setQueueConfiguration(component, qc);
        return qc;
    }

    public org.mule.runtime.core.util.queue.QueueConfiguration toQueueConfiguration(MuleContext context) {
        if (this.objectStore instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.objectStore)).setMuleContext(context);
        }
        if (DelegateQueueManager.isOldModeEnabled()) {
            return new QueueConfiguration(context, this.maxOutstandingMessages, this.objectStore);
        }
        return new DefaultQueueConfiguration(this.maxOutstandingMessages, this.objectStore.isPersistent());
    }

    public ListableObjectStore<Serializable> getObjectStore() {
        return this.objectStore;
    }

    public void setQueueStore(QueueStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public void addQueueStore(QueueStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public String toString() {
        return "QueueProfile{maxOutstandingMessage=" + this.maxOutstandingMessages + ", storeType=" + this.objectStore.getClass() + "}";
    }
}

