/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ThreadingProfile;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.WorkManager;
import org.mule.runtime.core.config.pool.ThreadPoolFactory;
import org.mule.runtime.core.work.MuleWorkManager;

public class ImmutableThreadingProfile
implements ThreadingProfile {
    private int maxThreadsActive;
    private int maxThreadsIdle;
    private int maxBufferSize;
    private long threadTTL;
    private long threadWaitTimeout;
    private int poolExhaustedAction;
    private boolean doThreading;
    private ThreadPoolFactory poolFactory = ThreadPoolFactory.newInstance();
    private ThreadingProfile.WorkManagerFactory workManagerFactory = new DefaultWorkManagerFactory();
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;
    private MuleContext muleContext;

    public ImmutableThreadingProfile(int maxThreadsActive, int maxThreadsIdle, int maxBufferSize, long threadTTL, long threadWaitTimeout, int poolExhaustedAction, boolean doThreading, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) {
        this.maxThreadsActive = maxThreadsActive;
        this.maxThreadsIdle = maxThreadsIdle;
        this.maxBufferSize = maxBufferSize;
        this.threadTTL = threadTTL;
        this.threadWaitTimeout = threadWaitTimeout;
        this.poolExhaustedAction = poolExhaustedAction;
        this.doThreading = doThreading;
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.threadFactory = threadFactory;
    }

    public ImmutableThreadingProfile(ThreadingProfile tp) {
        this(tp.getMaxThreadsActive(), tp.getMaxThreadsIdle(), tp.getMaxBufferSize(), tp.getThreadTTL(), tp.getThreadWaitTimeout(), tp.getPoolExhaustedAction(), tp.isDoThreading(), tp.getRejectedExecutionHandler(), tp.getThreadFactory());
    }

    @Override
    public int getMaxThreadsActive() {
        return this.maxThreadsActive;
    }

    @Override
    public int getMaxThreadsIdle() {
        return this.maxThreadsIdle;
    }

    @Override
    public long getThreadTTL() {
        return this.threadTTL;
    }

    @Override
    public long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    @Override
    public int getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void setMaxThreadsActive(int maxThreadsActive) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setMaxThreadsIdle(int maxThreadsIdle) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setThreadTTL(long threadTTL) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setThreadWaitTimeout(long threadWaitTimeout) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setPoolExhaustedAction(int poolExhaustPolicy) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @Override
    public void setMaxBufferSize(int maxBufferSize) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public ThreadingProfile.WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    @Override
    public void setWorkManagerFactory(ThreadingProfile.WorkManagerFactory workManagerFactory) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public WorkManager createWorkManager(String name, int shutdownTimeout) {
        return this.workManagerFactory.createWorkManager(new ImmutableThreadingProfile(this), name, shutdownTimeout);
    }

    @Override
    public ExecutorService createPool() {
        return this.createPool(null);
    }

    @Override
    public ExecutorService createPool(String name) {
        return this.poolFactory.createPool(name, new ImmutableThreadingProfile(this));
    }

    @Override
    public boolean isDoThreading() {
        return this.doThreading;
    }

    @Override
    public void setDoThreading(boolean doThreading) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public ThreadPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    @Override
    public ScheduledExecutorService createScheduledPool(String name) {
        return this.poolFactory.createScheduledPool(name, new ImmutableThreadingProfile(this));
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.workManagerFactory instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.workManagerFactory)).setMuleContext(this.muleContext);
        }
        this.poolFactory.setMuleContext(this.muleContext);
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return "ThreadingProfile{maxThreadsActive=" + this.maxThreadsActive + ", maxThreadsIdle=" + this.maxThreadsIdle + ", maxBufferSize=" + this.maxBufferSize + ", threadTTL=" + this.threadTTL + ", poolExhaustedAction=" + this.poolExhaustedAction + ", threadWaitTimeout=" + this.threadWaitTimeout + ", doThreading=" + this.doThreading + ", workManagerFactory=" + this.workManagerFactory + ", rejectedExecutionHandler=" + this.rejectedExecutionHandler + ", threadFactory=" + this.threadFactory + "}";
    }

    public static class DefaultWorkManagerFactory
    implements ThreadingProfile.WorkManagerFactory,
    MuleContextAware {
        protected MuleContext muleContext;

        @Override
        public WorkManager createWorkManager(ThreadingProfile profile, String name, int shutdownTimeout) {
            MuleWorkManager workManager = new MuleWorkManager(profile, name, shutdownTimeout);
            if (this.muleContext != null) {
                MuleContextAware contextAware = workManager;
                contextAware.setMuleContext(this.muleContext);
            }
            return workManager;
        }

        @Override
        public void setMuleContext(MuleContext context) {
            this.muleContext = context;
        }
    }
}

