/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.legacy.exception.ExceptionReader;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.registry.ServiceType;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.NotificationException;
import org.mule.runtime.core.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionHelper
extends org.mule.runtime.api.exception.ExceptionHelper {
    public static final String SERVICE_ROOT = "META-INF/services/";
    public static final String ERROR_CODE_PROPERTY = "error.code.property";
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHelper.class);
    private static String J2SE_VERSION = "";
    private static final String J2EE_VERSION = "1.3ee";
    private static Properties errorDocs = new Properties();
    private static Properties errorCodes = new Properties();
    private static Map<String, Properties> errorMappings = new HashMap<String, Properties>();
    private static Map<String, Boolean> disposeListenerRegistered = new HashMap<String, Boolean>();
    private static boolean initialised = false;

    private ExceptionHelper() {
    }

    private static void initialise() {
        try {
            if (initialised) {
                return;
            }
            J2SE_VERSION = System.getProperty("java.specification.version");
            String name = SERVICE_ROOT + ServiceType.EXCEPTION.getPath() + "/mule-exception-codes.properties";
            InputStream in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
            if (in == null) {
                throw new IllegalArgumentException("Failed to load resource: " + name);
            }
            errorCodes.load(in);
            in.close();
            name = SERVICE_ROOT + ServiceType.EXCEPTION.getPath() + "/mule-exception-config.properties";
            in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
            if (in == null) {
                throw new IllegalArgumentException("Failed to load resource: " + name);
            }
            errorDocs.load(in);
            in.close();
            initialised = true;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToLoad("Exception resources"), (Throwable)e);
        }
    }

    public static int getErrorCode(Class exception) {
        return -1;
    }

    private static Properties getErrorMappings(String protocol, MuleContext muleContext) {
        Properties m = errorMappings.get(ExceptionHelper.getErrorMappingCacheKey(protocol, muleContext));
        if (m != null) {
            return m;
        }
        String name = SERVICE_ROOT + ServiceType.EXCEPTION.getPath() + "/" + protocol + "-exception-mappings.properties";
        Properties p = PropertiesUtils.loadAllProperties(name, muleContext.getExecutionClassLoader());
        errorMappings.put(ExceptionHelper.getErrorMappingCacheKey(protocol, muleContext), p);
        ExceptionHelper.registerAppDisposeListener(muleContext);
        return p;
    }

    private static void registerAppDisposeListener(MuleContext muleContext) {
        if (!disposeListenerRegistered.containsKey(muleContext.getConfiguration().getId())) {
            try {
                muleContext.registerListener(ExceptionHelper.createClearCacheListenerOnContextDispose(muleContext));
                disposeListenerRegistered.put(muleContext.getConfiguration().getId(), true);
            }
            catch (NotificationException e) {
                throw new MuleRuntimeException((Throwable)((Object)e));
            }
        }
    }

    private static MuleContextNotificationListener<MuleContextNotification> createClearCacheListenerOnContextDispose(final MuleContext muleContext) {
        return new MuleContextNotificationListener<MuleContextNotification>(){

            @Override
            public boolean isBlocking() {
                return false;
            }

            @Override
            public void onNotification(MuleContextNotification notification) {
                if (notification.getAction() == 108) {
                    ExceptionHelper.clearCacheFor(muleContext);
                    disposeListenerRegistered.remove(notification.getMuleContext().getConfiguration().getId());
                }
            }
        };
    }

    private static String getErrorMappingCacheKey(String protocol, MuleContext muleContext) {
        return protocol + "-" + muleContext.getConfiguration().getId();
    }

    public static String getErrorCodePropertyName(String protocol, MuleContext muleContext) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase(), muleContext);
        if (mappings == null) {
            return null;
        }
        return mappings.getProperty(ERROR_CODE_PROPERTY);
    }

    public static String getErrorMapping(String protocol, Class exception, MuleContext muleContext) {
        String code = ExceptionHelper.getTransportErrorMapping(protocol, exception, muleContext);
        if (code != null) {
            return code;
        }
        code = String.valueOf(ExceptionHelper.getErrorCode(exception));
        return ExceptionHelper.getErrorMappings(protocol, muleContext).getProperty(code, code);
    }

    public static String getTransportErrorMapping(String protocol, Class exception, MuleContext muleContext) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase(), muleContext);
        if (mappings == null) {
            logger.info("No mappings found for protocol: " + protocol);
            return String.valueOf(ExceptionHelper.getErrorCode(exception));
        }
        Class clazz = exception;
        String code = null;
        while (!clazz.equals(Object.class)) {
            code = mappings.getProperty(clazz.getName());
            if (code == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            return code;
        }
        return null;
    }

    @Deprecated
    public static String getJavaDocUrl(Class<?> exception) {
        return ExceptionHelper.getDocUrl("javadoc.", exception.getName());
    }

    @Deprecated
    public static String getDocUrl(Class<?> exception) {
        return ExceptionHelper.getDocUrl("doc.", exception.getName());
    }

    private static String getDocUrl(String prefix, String packageName) {
        String url;
        String key = prefix;
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            key = key + J2SE_VERSION;
        }
        if ((url = ExceptionHelper.getUrl(key, packageName)) == null && (packageName.startsWith("java.") || packageName.startsWith("javax."))) {
            key = prefix + J2EE_VERSION;
            url = ExceptionHelper.getUrl(key, packageName);
        }
        if (url != null) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            String s = packageName.replaceAll("[.]", "/");
            s = s + ".html";
            url = url + s;
        }
        return url;
    }

    private static String getUrl(String key, String packageName) {
        String url = null;
        if (!key.endsWith(".")) {
            key = key + ".";
        }
        while (packageName.length() > 0 && (url = errorDocs.getProperty(key + packageName, null)) == null) {
            int i = packageName.lastIndexOf(".");
            if (i == -1) {
                packageName = "";
                continue;
            }
            packageName = packageName.substring(0, i);
        }
        return url;
    }

    public static Throwable sanitizeIfNeeded(Throwable t) {
        return fullStackTraces ? t : ExceptionHelper.sanitize((Throwable)t);
    }

    public static Throwable getRootParentException(Throwable t) {
        Throwable cause = t;
        Throwable parent = t;
        while (cause != null) {
            if (cause.getCause() == null) {
                return parent;
            }
            parent = cause;
            if (t != (cause = ExceptionHelper.getExceptionReader((Throwable)cause).getCause(cause))) continue;
            break;
        }
        return t;
    }

    public static <T> T traverseCauseHierarchy(Throwable e, ExceptionEvaluator<T> evaluator) {
        LinkedList<Throwable> exceptions = new LinkedList<Throwable>();
        exceptions.add(e);
        while (e.getCause() != null && !e.getCause().equals(e)) {
            exceptions.addFirst(e.getCause());
            e = e.getCause();
        }
        for (Throwable exception : exceptions) {
            T value = evaluator.evaluate(exception);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String writeException(Throwable t) {
        ExceptionReader er = ExceptionHelper.getExceptionReader((Throwable)t);
        StringBuilder msg = new StringBuilder();
        msg.append(er.getMessage(t)).append(". Type: ").append(t.getClass());
        return msg.toString();
    }

    private static void clearCacheFor(MuleContext muleContext) {
        ArrayList<String> entriesToRemove = new ArrayList<String>();
        for (String key : errorMappings.keySet()) {
            if (!key.endsWith(muleContext.getConfiguration().getId())) continue;
            entriesToRemove.add(key);
        }
        for (String key : entriesToRemove) {
            errorMappings.remove(key);
        }
    }

    static {
        ExceptionHelper.initialise();
    }

    public static interface ExceptionEvaluator<T> {
        public T evaluate(Throwable var1);
    }
}

