/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ThreadingProfile;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.WorkManager;
import org.mule.runtime.core.config.ImmutableThreadingProfile;
import org.mule.runtime.core.config.pool.ThreadPoolFactory;

public class ChainedThreadingProfile
implements ThreadingProfile {
    private Integer maxThreadsActive;
    private Integer maxThreadsIdle;
    private Integer maxBufferSize;
    private Long threadTTL;
    private Long threadWaitTimeout;
    private Integer poolExhaustedAction;
    private Boolean doThreading;
    private ThreadPoolFactory poolFactory = ThreadPoolFactory.newInstance();
    private ThreadingProfile.WorkManagerFactory workManagerFactory = new ImmutableThreadingProfile.DefaultWorkManagerFactory();
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;
    private ThreadingProfile delegate;
    private MuleContext muleContext;

    public ChainedThreadingProfile() {
        this(DEFAULT_THREADING_PROFILE);
    }

    public ChainedThreadingProfile(ThreadingProfile delegate) {
        this(delegate, true);
    }

    public ChainedThreadingProfile(ThreadingProfile delegate, boolean dynamic) {
        if (!dynamic) {
            delegate = new ImmutableThreadingProfile(delegate);
        }
        this.delegate = delegate;
    }

    @Override
    public int getMaxThreadsActive() {
        return null != this.maxThreadsActive ? this.maxThreadsActive.intValue() : this.delegate.getMaxThreadsActive();
    }

    @Override
    public int getMaxThreadsIdle() {
        return null != this.maxThreadsIdle ? this.maxThreadsIdle.intValue() : this.delegate.getMaxThreadsIdle();
    }

    @Override
    public long getThreadTTL() {
        return null != this.threadTTL ? this.threadTTL.longValue() : this.delegate.getThreadTTL();
    }

    @Override
    public long getThreadWaitTimeout() {
        return null != this.threadWaitTimeout ? this.threadWaitTimeout.longValue() : this.delegate.getThreadWaitTimeout();
    }

    @Override
    public int getPoolExhaustedAction() {
        return null != this.poolExhaustedAction ? this.poolExhaustedAction.intValue() : this.delegate.getPoolExhaustedAction();
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void setMaxThreadsActive(int maxThreadsActive) {
        this.maxThreadsActive = maxThreadsActive;
    }

    @Override
    public void setMaxThreadsIdle(int maxThreadsIdle) {
        this.maxThreadsIdle = maxThreadsIdle;
    }

    @Override
    public void setThreadTTL(long threadTTL) {
        this.threadTTL = threadTTL;
    }

    @Override
    public void setThreadWaitTimeout(long threadWaitTimeout) {
        this.threadWaitTimeout = threadWaitTimeout;
    }

    @Override
    public void setPoolExhaustedAction(int poolExhaustPolicy) {
        this.poolExhaustedAction = poolExhaustPolicy;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public int getMaxBufferSize() {
        return null != this.maxBufferSize ? this.maxBufferSize.intValue() : this.delegate.getMaxBufferSize();
    }

    @Override
    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public ThreadingProfile.WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    @Override
    public void setWorkManagerFactory(ThreadingProfile.WorkManagerFactory workManagerFactory) {
        this.workManagerFactory = workManagerFactory;
    }

    @Override
    public WorkManager createWorkManager(String name, int shutdownTimeout) {
        return this.workManagerFactory.createWorkManager(new ImmutableThreadingProfile(this), name, shutdownTimeout);
    }

    @Override
    public ExecutorService createPool() {
        return this.createPool(null);
    }

    @Override
    public ExecutorService createPool(String name) {
        return this.poolFactory.createPool(name, new ImmutableThreadingProfile(this));
    }

    @Override
    public boolean isDoThreading() {
        return null != this.doThreading ? this.doThreading.booleanValue() : this.delegate.isDoThreading();
    }

    @Override
    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    @Override
    public ThreadPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    @Override
    public ScheduledExecutorService createScheduledPool(String name) {
        return this.poolFactory.createScheduledPool(name, new ImmutableThreadingProfile(this));
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        if (this.workManagerFactory instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.workManagerFactory)).setMuleContext(muleContext);
        }
        this.poolFactory.setMuleContext(muleContext);
    }

    public String toString() {
        return "ThreadingProfile{maxThreadsActive=" + this.maxThreadsActive + ", maxThreadsIdle=" + this.maxThreadsIdle + ", maxBufferSize=" + this.maxBufferSize + ", threadTTL=" + this.threadTTL + ", poolExhaustedAction=" + this.poolExhaustedAction + ", threadWaitTimeout=" + this.threadWaitTimeout + ", doThreading=" + this.doThreading + ", workManagerFactory=" + this.workManagerFactory + ", rejectedExecutionHandler=" + this.rejectedExecutionHandler + ", threadFactory=" + this.threadFactory + "}";
    }
}

