/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.client;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.client.MuleClient;
import org.mule.runtime.core.api.client.OperationOptions;
import org.mule.runtime.core.api.client.SimpleOptionsBuilder;
import org.mule.runtime.core.api.connector.ConnectorOperationLocator;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.DefaultMessagingExceptionStrategy;
import org.mule.runtime.core.functional.Either;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.message.ErrorBuilder;

public class DefaultLocalMuleClient
implements MuleClient {
    public static final String MESSAGE_FILTERED_ERROR_MESSAGE = "message filtered";
    protected final MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private ConnectorOperationLocator connectorOperatorLocator;

    public DefaultLocalMuleClient(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.flowConstruct = new MuleClientFlowConstruct(muleContext);
    }

    protected ConnectorOperationLocator getConnectorMessageProcessLocator() {
        if (this.connectorOperatorLocator == null) {
            this.connectorOperatorLocator = (ConnectorOperationLocator)this.muleContext.getRegistry().get("_muleConnectorMessageProcessorLocator");
            if (this.connectorOperatorLocator == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find required %s in the registry under key %s", (Object[])new Object[]{ConnectorOperationLocator.class.getName(), "_muleConnectorMessageProcessorLocator"}));
            }
        }
        return this.connectorOperatorLocator;
    }

    @Override
    public void dispatch(String url, Object payload, Map<String, Serializable> messageProperties) throws MuleException {
        this.dispatch(url, this.createMessage(payload, messageProperties));
    }

    @Override
    public Either<Error, InternalMessage> send(String url, Object payload, Map<String, Serializable> messageProperties) throws MuleException {
        return this.send(url, this.createMessage(payload, messageProperties));
    }

    @Override
    public Either<Error, InternalMessage> send(String url, InternalMessage message) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, ((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().outbound()).build(), MessageExchangePattern.REQUEST_RESPONSE);
        if (connectorMessageProcessor != null) {
            if (connectorMessageProcessor instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)connectorMessageProcessor)).setFlowConstruct(this.flowConstruct);
            }
            return this.createEitherResult(connectorMessageProcessor.process(this.createRequestResponseMuleEvent(message)));
        }
        throw this.createUnsupportedUrlException(url);
    }

    private Either<Error, InternalMessage> createEitherResult(Event muleEvent) {
        if (muleEvent == null) {
            ErrorType anyErrorType = this.muleContext.getErrorTypeRepository().getAnyErrorType();
            return Either.left(ErrorBuilder.builder((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)MESSAGE_FILTERED_ERROR_MESSAGE))).errorType(anyErrorType).build());
        }
        if (!muleEvent.getError().isPresent()) {
            return Either.right(muleEvent.getMessage());
        }
        return Either.left(muleEvent.getError().get());
    }

    @Override
    public Either<Error, InternalMessage> send(String url, InternalMessage message, OperationOptions operationOptions) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, operationOptions, MessageExchangePattern.REQUEST_RESPONSE);
        if (connectorMessageProcessor != null) {
            if (connectorMessageProcessor instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)connectorMessageProcessor)).setFlowConstruct(this.flowConstruct);
            }
            return this.createEitherResult(this.returnEvent(connectorMessageProcessor.process(this.createRequestResponseMuleEvent(message))));
        }
        throw this.createUnsupportedUrlException(url);
    }

    private MuleException createUnsupportedUrlException(String url) {
        return new DefaultMuleException("No installed connector supports url " + url);
    }

    @Override
    public Either<Error, InternalMessage> send(String url, Object payload, Map<String, Serializable> messageProperties, long timeout) throws MuleException {
        return this.send(url, this.createMessage(payload, messageProperties), timeout);
    }

    @Override
    public Either<Error, InternalMessage> send(String url, InternalMessage message, long timeout) throws MuleException {
        return this.send(url, message, ((SimpleOptionsBuilder)((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().outbound()).responseTimeout(timeout)).build());
    }

    protected InternalMessage createMessage(Object payload, Map<String, Serializable> messageProperties) {
        InternalMessage.Builder builder = InternalMessage.builder().payload(payload);
        if (messageProperties != null) {
            builder.outboundProperties(messageProperties);
        }
        return builder.build();
    }

    @Override
    public void dispatch(String url, InternalMessage message) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, ((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().outbound()).build(), MessageExchangePattern.ONE_WAY);
        if (connectorMessageProcessor != null) {
            if (connectorMessageProcessor instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)connectorMessageProcessor)).setFlowConstruct(this.flowConstruct);
            }
        } else {
            throw this.createUnsupportedUrlException(url);
        }
        connectorMessageProcessor.process(this.createOneWayMuleEvent(message));
    }

    @Override
    public void dispatch(String url, InternalMessage message, OperationOptions operationOptions) throws MuleException {
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, operationOptions, MessageExchangePattern.ONE_WAY);
        if (connectorMessageProcessor != null) {
            if (connectorMessageProcessor instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)connectorMessageProcessor)).setFlowConstruct(this.flowConstruct);
            }
            connectorMessageProcessor.process(this.createOneWayMuleEvent(message));
        } else {
            this.dispatch(url, message);
        }
    }

    @Override
    public Either<Error, Optional<InternalMessage>> request(String url, long timeout) throws MuleException {
        OperationOptions operationOptions = ((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().responseTimeout(timeout)).build();
        Processor connectorMessageProcessor = this.getConnectorMessageProcessLocator().locateConnectorOperation(url, operationOptions, MessageExchangePattern.ONE_WAY);
        if (connectorMessageProcessor != null) {
            Event event;
            if (connectorMessageProcessor instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)connectorMessageProcessor)).setFlowConstruct(this.flowConstruct);
            }
            if ((event = connectorMessageProcessor.process(this.createOneWayMuleEvent(InternalMessage.builder().nullPayload().build()))) == null) {
                return Either.right(Optional.empty());
            }
            if (event.getError().isPresent()) {
                return Either.left(event.getError().get());
            }
            return Either.right(Optional.ofNullable(event.getMessage()));
        }
        return Either.right(Optional.empty());
    }

    protected Event createRequestResponseMuleEvent(InternalMessage message) throws MuleException {
        return this.baseEventBuilder(message).exchangePattern(MessageExchangePattern.REQUEST_RESPONSE).build();
    }

    protected Event createOneWayMuleEvent(InternalMessage message) throws MuleException {
        return this.baseEventBuilder(message).exchangePattern(MessageExchangePattern.ONE_WAY).build();
    }

    private Event.Builder baseEventBuilder(InternalMessage message) {
        return Event.builder(DefaultEventContext.create(this.flowConstruct, "muleClient")).message(message).flow(this.flowConstruct);
    }

    protected Event returnEvent(Event event) {
        if (event != null) {
            return event;
        }
        return null;
    }

    public static class MuleClientFlowConstruct
    implements FlowConstruct {
        MuleContext muleContext;

        public MuleClientFlowConstruct(MuleContext muleContext) {
            this.muleContext = muleContext;
        }

        public String getName() {
            return "MuleClient";
        }

        @Override
        public String getUniqueIdString() {
            return this.muleContext.getUniqueIdString();
        }

        @Override
        public String getServerId() {
            return this.muleContext.getId();
        }

        @Override
        public MessagingExceptionHandler getExceptionListener() {
            return new DefaultMessagingExceptionStrategy(this.muleContext);
        }

        @Override
        public LifecycleState getLifecycleState() {
            return null;
        }

        @Override
        public FlowConstructStatistics getStatistics() {
            return null;
        }

        @Override
        public MuleContext getMuleContext() {
            return this.muleContext;
        }

        public MessageProcessorChain getMessageProcessorChain() {
            return null;
        }
    }
}

