/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.security;

import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.SecurityException;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.config.i18n.CoreMessages;

public class NotPermittedException
extends SecurityException {
    private static final long serialVersionUID = -6664384216189042673L;

    public NotPermittedException(I18nMessage message) {
        super(message);
    }

    public NotPermittedException(I18nMessage message, Throwable cause) {
        super(message, cause);
    }

    public NotPermittedException(Event event, SecurityContext context, SecurityFilter filter) {
        super(NotPermittedException.constructMessage(context, event.getContext().getOriginatingConnectorName(), filter));
    }

    private static I18nMessage constructMessage(SecurityContext context, String originatingConnectorName, SecurityFilter filter) {
        I18nMessage m = context == null ? CoreMessages.authSetButNoContext(filter.getClass().getName()) : CoreMessages.authFailedForUser(context.getAuthentication().getPrincipal());
        m.setNextMessage(CoreMessages.authorizationDeniedOnEndpoint(originatingConnectorName));
        return m;
    }
}

