/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;

public class DefaultMessageProcessorPathElement
implements MessageProcessorPathElement {
    private MessageProcessorPathElement parent;
    private List<MessageProcessorPathElement> children;
    private Processor messageProcessor;
    private String name;

    public DefaultMessageProcessorPathElement(Processor messageProcessor, String name) {
        this.messageProcessor = messageProcessor;
        this.name = this.escape(name);
        this.children = new ArrayList<MessageProcessorPathElement>();
    }

    @Override
    public MessageProcessorPathElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MessageProcessorPathElement parent) {
        this.parent = parent;
    }

    @Override
    public List<MessageProcessorPathElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public MessageProcessorPathElement addChild(Processor mp) {
        int size = this.children.size();
        DefaultMessageProcessorPathElement result = new DefaultMessageProcessorPathElement(mp, String.valueOf(size));
        this.addChild(result);
        return result;
    }

    @Override
    public MessageProcessorPathElement addChild(String name) {
        DefaultMessageProcessorPathElement result = new DefaultMessageProcessorPathElement(null, name);
        this.addChild(result);
        return result;
    }

    @Override
    public Processor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void addChild(MessageProcessorPathElement mp) {
        this.children.add(mp);
        mp.setParent(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.parent == null ? "/" + this.getName() : this.parent.getPath() + "/" + this.getName();
    }

    private String escape(String name) {
        StringBuilder builder = new StringBuilder(name.length() * 2);
        int previous = 32;
        for (int n : name.toCharArray()) {
            builder.append(n == 47 && previous != 92 ? "\\/" : Character.valueOf((char)n));
            previous = n;
        }
        return builder.toString();
    }
}

