/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.NoSuchElementException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.MuleEvent;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.connector.ReplyToHandler;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.message.DefaultEventBuilder;
import org.mule.runtime.core.message.GroupCorrelation;

public interface Event
extends MuleEvent {
    public EventContext getContext();

    public GroupCorrelation getGroupCorrelation();

    public String getCorrelationId();

    public InternalMessage getMessage();

    @Deprecated
    public byte[] getMessageAsBytes(MuleContext var1) throws MuleException;

    @Deprecated
    public <T> T transformMessage(Class<T> var1, MuleContext var2) throws TransformerException;

    @Deprecated
    public Object transformMessage(DataType var1, MuleContext var2) throws TransformerException;

    @Deprecated
    public String transformMessageToString(MuleContext var1) throws TransformerException;

    @Deprecated
    public String getMessageAsString(MuleContext var1) throws MuleException;

    @Deprecated
    public String getMessageAsString(Charset var1, MuleContext var2) throws MuleException;

    @Deprecated
    public MuleSession getSession();

    @Deprecated
    public FlowConstruct getFlowConstruct();

    @Deprecated
    public MuleContext getMuleContext();

    @Deprecated
    public MessageExchangePattern getExchangePattern();

    @Deprecated
    public ReplyToHandler getReplyToHandler();

    @Deprecated
    public Object getReplyToDestination();

    @Deprecated
    public boolean isSynchronous();

    public boolean isNotificationsEnabled();

    public FlowCallStack getFlowCallStack();

    public SecurityContext getSecurityContext();

    @Deprecated
    public String getLegacyCorrelationId();

    public static Builder builder(EventContext context) {
        return new DefaultEventBuilder(context);
    }

    public static Builder builder(Event event) {
        return new DefaultEventBuilder(event);
    }

    public static <T> T getVariableValueOrNull(String key, Event event) {
        TypedValue value = null;
        try {
            value = event.getVariable(key);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return (T)(value != null ? value.getValue() : null);
    }

    public static Event getCurrentEvent() {
        return (Event)CurrentEventHolder.currentEvent.get();
    }

    public static void setCurrentEvent(Event event) {
        CurrentEventHolder.currentEvent.set(event);
    }

    public static interface Builder {
        public Builder message(InternalMessage var1);

        public Builder variables(Map<String, Object> var1);

        public Builder addVariable(String var1, Object var2);

        public Builder addVariable(String var1, Object var2, DataType var3);

        public Builder removeVariable(String var1);

        @Deprecated
        public Builder correlationId(String var1);

        public Builder groupCorrelation(GroupCorrelation var1);

        public Builder error(Error var1);

        @Deprecated
        public Builder synchronous(boolean var1);

        @Deprecated
        public Builder exchangePattern(MessageExchangePattern var1);

        @Deprecated
        public Builder replyToHandler(ReplyToHandler var1);

        @Deprecated
        public Builder replyToDestination(Object var1);

        @Deprecated
        public Builder flow(FlowConstruct var1);

        @Deprecated
        public Builder disableNotifications();

        @Deprecated
        public Builder session(MuleSession var1);

        public Event build();
    }

    public static class CurrentEventHolder {
        private static final ThreadLocal<Event> currentEvent = new ThreadLocal();
    }
}

