/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.MessageTransformer;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.TransformerUtils;
import org.mule.runtime.core.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationService {
    private static final Logger logger = LoggerFactory.getLogger(TransformationService.class);
    private MuleContext muleContext;

    public TransformationService(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public InternalMessage applyTransformers(InternalMessage message, Event event, List<? extends Transformer> transformers) throws MuleException {
        return this.applyAllTransformers(message, event, transformers);
    }

    public InternalMessage applyTransformers(InternalMessage message, Event event, Transformer ... transformers) throws MuleException {
        return this.applyAllTransformers(message, event, Arrays.asList(transformers));
    }

    public InternalMessage transform(InternalMessage message, DataType outputDataType) throws TransformerException {
        Preconditions.checkNotNull((Object)message, (Object)"Message cannot be null");
        Preconditions.checkNotNull((Object)outputDataType, (Object)"DataType cannot be null");
        return InternalMessage.builder(message).payload(this.getPayload(message, outputDataType, this.resolveEncoding(message))).build();
    }

    public String getPayloadForLogging(InternalMessage message) {
        return this.getPayloadForLogging(message, this.resolveEncoding(message));
    }

    protected Charset resolveEncoding(InternalMessage message) {
        return message.getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(this.muleContext));
    }

    public String getPayloadForLogging(InternalMessage message, Charset encoding) {
        DataType dataType = message.getPayload().getDataType();
        if (!dataType.isStreamType()) {
            try {
                return (String)this.getPayload(message, DataType.STRING, encoding);
            }
            catch (TransformerException e) {
                return "Payload could not be converted to a String. Payload type is " + dataType.getType();
            }
        }
        return "Payload is a stream of type: " + dataType.getType();
    }

    private InternalMessage applyAllTransformers(InternalMessage message, Event event, List<? extends Transformer> transformers) throws MuleException {
        InternalMessage result = message;
        if (!transformers.isEmpty()) {
            for (int index = 0; index < transformers.size(); ++index) {
                Class srcCls;
                DataType originalSourceType;
                Transformer transformer = transformers.get(index);
                if (transformer.isSourceDataTypeSupported(originalSourceType = DataType.fromType((Class)(srcCls = result.getPayload().getDataType().getType())))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using " + transformer + " to transform payload.");
                    }
                    result = this.transformMessage(result, event, transformer);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Transformer " + transformer + " doesn't support the source payload: " + srcCls);
                }
                if (this.canSkipTransformer(result, transformers, index)) continue;
                Transformer implicitTransformer = this.muleContext.getDataTypeConverterResolver().resolve(originalSourceType, transformer.getSourceDataTypes());
                if (implicitTransformer != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Performing implicit transformation with: " + transformer);
                    }
                    result = this.transformMessage(result, event, implicitTransformer);
                    result = this.transformMessage(result, event, transformer);
                    continue;
                }
                throw new IllegalArgumentException("Cannot apply transformer " + transformer + " on source payload: " + srcCls);
            }
        }
        return result;
    }

    private boolean canSkipTransformer(InternalMessage message, List<? extends Transformer> transformers, int index) {
        Transformer transformer = transformers.get(index);
        boolean skipConverter = false;
        if (transformer instanceof Converter) {
            if (index == transformers.size() - 1) {
                try {
                    TransformerUtils.checkTransformerReturnClass(transformer, message.getPayload().getValue());
                    skipConverter = true;
                }
                catch (TransformerException transformerException) {}
            } else {
                skipConverter = true;
            }
        }
        if (skipConverter) {
            logger.debug("Skipping converter: " + transformer);
        }
        return skipConverter;
    }

    private InternalMessage transformMessage(InternalMessage message, Event event, Transformer transformer) throws MessageTransformerException, TransformerException {
        Object result = transformer instanceof MessageTransformer ? ((MessageTransformer)transformer).transform((Object)message, event) : transformer.transform(message);
        if (result instanceof InternalMessage) {
            return (InternalMessage)result;
        }
        InternalMessage messagePostTransform = event != null && event.getMessage() != null ? event.getMessage() : message;
        return InternalMessage.builder(messagePostTransform).payload(result).mediaType(this.mergeMediaType(messagePostTransform, transformer.getReturnDataType())).build();
    }

    private MediaType mergeMediaType(InternalMessage message, DataType transformed) {
        DataType original = message.getPayload().getDataType();
        MediaType mimeType = MediaType.ANY.matches(transformed.getMediaType()) ? original.getMediaType() : transformed.getMediaType();
        Charset encoding = transformed.getMediaType().getCharset().orElse(message.getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(this.muleContext)));
        return DataType.builder().mediaType(mimeType).charset(encoding).build().getMediaType();
    }

    private <T> T getPayload(InternalMessage message, DataType resultType, Charset encoding) throws TransformerException {
        if (resultType == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("resultType").getMessage());
        }
        DataType dataType = DataType.builder((DataType)resultType).type(message.getPayload().getDataType().getType()).build();
        if (resultType.isCompatibleWith(dataType)) {
            return (T)message.getPayload().getValue();
        }
        Transformer transformer = this.muleContext.getRegistry().lookupTransformer(dataType, resultType);
        if (transformer == null) {
            throw new TransformerException(CoreMessages.noTransformerFoundForMessage(dataType, resultType));
        }
        Object result = transformer.transform(message, encoding);
        if (!resultType.getType().isAssignableFrom(result.getClass())) {
            throw new TransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(resultType, result));
        }
        return (T)result;
    }
}

