/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core;

import java.io.Serializable;
import java.time.OffsetTime;
import org.mule.runtime.core.api.CoreEventContext;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.context.notification.DefaultProcessorsTrace;
import org.mule.runtime.core.management.stats.ProcessingTime;

public final class DefaultEventContext
implements CoreEventContext,
Serializable {
    private static final long serialVersionUID = -3664490832964509653L;
    private final String id;
    private final String correlationId;
    private final OffsetTime receivedDate = OffsetTime.now();
    private final String serverId;
    private final String flowName;
    private final String connectorName;
    private final ProcessingTime processingTime;
    private final ProcessorsTrace processorsTrace = new DefaultProcessorsTrace();

    public static EventContext create(FlowConstruct flow, String connectorName) {
        return DefaultEventContext.create(flow, connectorName, null);
    }

    public static EventContext create(FlowConstruct flow, String connectorName, String correlationId) {
        return new DefaultEventContext(flow, connectorName, correlationId);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId != null ? this.correlationId : this.id;
    }

    @Override
    public OffsetTime getReceivedTime() {
        return this.receivedDate;
    }

    @Override
    public String getOriginatingFlowName() {
        return this.flowName;
    }

    @Override
    public String getOriginatingConnectorName() {
        return this.connectorName;
    }

    @Override
    public ProcessingTime getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public boolean isCorrelationIdFromSource() {
        return this.correlationId != null;
    }

    @Override
    public ProcessorsTrace getProcessorsTrace() {
        return this.processorsTrace;
    }

    private DefaultEventContext(FlowConstruct flow, String connectorName, String correlationId) {
        this.id = flow.getUniqueIdString();
        this.serverId = flow.getServerId();
        this.flowName = flow.getName();
        this.connectorName = connectorName;
        this.processingTime = ProcessingTime.newInstance(flow);
        this.correlationId = correlationId;
    }

    public String toString() {
        return "DefaultMessageExecutionContext { id: " + this.id + "; correlationId: " + this.correlationId + "; flowName: " + this.flowName + "; serverId: " + this.serverId + " }";
    }
}

