/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.FileUtils;

public final class JarUtils {
    private static final String MULE_MODULE_FILENAME = "lib" + File.separator + "module";
    private static final String MULE_LIB_FILENAME = "lib" + File.separator + "mule";
    private static final String MULE_HOME = System.getProperty("mule.home");
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";
    private static final Log logger = LogFactory.getLog(JarUtils.class);

    private JarUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap readJarFileEntries(File jarFile) throws Exception {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        JarFile jarFileWrapper = null;
        if (jarFile != null) {
            logger.debug((Object)("Reading jar entries from " + jarFile.getAbsolutePath()));
            try {
                jarFileWrapper = new JarFile(jarFile);
                Enumeration<JarEntry> iter = jarFileWrapper.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    InputStream entryStream = jarFileWrapper.getInputStream(zipEntry);
                    try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                        IOUtils.copy((InputStream)entryStream, (OutputStream)byteArrayStream);
                        entries.put(zipEntry.getName(), byteArrayStream.toByteArray());
                        logger.debug((Object)("Read jar entry " + zipEntry.getName() + " from " + jarFile.getAbsolutePath()));
                    }
                }
            }
            finally {
                if (jarFileWrapper != null) {
                    try {
                        jarFileWrapper.close();
                    }
                    catch (Exception ignore) {
                        logger.debug((Object)ignore);
                    }
                }
            }
        }
        return entries;
    }

    public static void appendJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        if (entries != null) {
            LinkedHashMap combinedEntries = JarUtils.readJarFileEntries(jarFile);
            combinedEntries.putAll(entries);
            File tmpJarFile = File.createTempFile(jarFile.getName(), null);
            JarUtils.createJarFileEntries(tmpJarFile, combinedEntries);
            FileUtils.deleteFile(jarFile);
            FileUtils.renameFile(tmpJarFile, jarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        ZipOutputStream jarStream = null;
        FileOutputStream fileStream = null;
        if (jarFile != null) {
            logger.debug((Object)("Creating jar file " + jarFile.getAbsolutePath()));
            try {
                fileStream = new FileOutputStream(jarFile);
                jarStream = new JarOutputStream(fileStream);
                if (entries != null && !entries.isEmpty()) {
                    for (String jarFilePath : entries.keySet()) {
                        Object content = entries.get(jarFilePath);
                        JarEntry entry = new JarEntry(jarFilePath);
                        ((JarOutputStream)jarStream).putNextEntry(entry);
                        logger.debug((Object)("Adding jar entry " + jarFilePath + " to " + jarFile.getAbsolutePath()));
                        if (content instanceof String) {
                            JarUtils.writeJarEntry((OutputStream)jarStream, ((String)content).getBytes());
                            continue;
                        }
                        if (content instanceof byte[]) {
                            JarUtils.writeJarEntry((OutputStream)jarStream, (byte[])content);
                            continue;
                        }
                        if (!(content instanceof File)) continue;
                        JarUtils.writeJarEntry((OutputStream)jarStream, (File)content);
                    }
                }
                jarStream.flush();
                fileStream.getFD().sync();
            }
            finally {
                if (jarStream != null) {
                    try {
                        jarStream.close();
                    }
                    catch (Exception jarNotClosed) {
                        logger.debug((Object)jarNotClosed);
                    }
                }
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (Exception fileNotClosed) {
                        logger.debug((Object)fileNotClosed);
                    }
                }
            }
        }
    }

    private static void writeJarEntry(OutputStream stream, byte[] entry) throws IOException {
        stream.write(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeJarEntry(OutputStream stream, File entry) throws IOException {
        FileInputStream fileContentStream = null;
        try {
            fileContentStream = new FileInputStream(entry);
            IOUtils.copy((InputStream)fileContentStream, (OutputStream)stream);
        }
        finally {
            if (fileContentStream != null) {
                try {
                    fileContentStream.close();
                }
                catch (Exception fileContentNotClosed) {
                    logger.debug((Object)fileContentNotClosed);
                }
            }
        }
    }

    public static File getMuleHomeFile() {
        return new File(MULE_HOME);
    }

    public static File getMuleLibDir() {
        return new File(MULE_HOME + File.separator + MULE_LIB_FILENAME);
    }

    public static File getMuleModuleDir() {
        return new File(MULE_HOME + File.separator + MULE_MODULE_FILENAME);
    }

    public static File getMuleLocalJarFile() {
        return new File(JarUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME);
    }
}

