/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.source.MessageSource;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.MessageReceiver;
import org.mule.execution.MessageProcessContext;

public class TransportMessageProcessContext
implements MessageProcessContext {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final MessageReceiver messageReceiver;
    private WorkManager flowExecutionWorkManager;

    public TransportMessageProcessContext(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public TransportMessageProcessContext(MessageReceiver messageReceiver, WorkManager flowExecutionWorkManager) {
        this.messageReceiver = messageReceiver;
        this.flowExecutionWorkManager = flowExecutionWorkManager;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageReceiver.getEndpoint();
    }

    protected MessageSource getMessageReceiver() {
        return this.messageReceiver;
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.messageReceiver.getFlowConstruct();
    }

    @Override
    public boolean supportsAsynchronousProcessing() {
        return this.flowExecutionWorkManager != null;
    }

    @Override
    public WorkManager getFlowExecutionWorkManager() {
        return this.flowExecutionWorkManager;
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.messageReceiver.getEndpoint().getTransactionConfig();
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.messageReceiver.getEndpoint().getMuleContext().getExecutionClassLoader();
    }
}

