/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.MuleSession;
import org.mule.api.model.SessionException;
import org.mule.api.serialization.SerializationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.session.DefaultMuleSession;
import org.mule.session.SerializeOnlySessionHandler;
import org.mule.util.Base64;

public class SerializeAndEncodeSessionHandler
extends SerializeOnlySessionHandler {
    private static final byte[] SECRET_KEY;
    private static final int SIGNATURE_LENGTH = 32;
    private static final Mac MAC_SIGNER;
    public static final String SESSION_SIGN_SECRET_KEY = "mule.session.sign.secretKey";
    public static final String SESSION_SIGN_CH_SECRET_KEY = "mule.session.sign.cloudHub.secretKey";

    @Override
    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        byte[] serializedSession;
        MuleSession session = null;
        String serializedEncodedSession = (String)message.getInboundProperty("MULE_SESSION");
        if (serializedEncodedSession != null && (serializedSession = Base64.decodeWithoutUnzipping(serializedEncodedSession)) != null) {
            String endpoint = this.getEndpoint(message);
            boolean signatureOk = false;
            try {
                byte[] signedSerializedSession = this.getSigned(serializedSession, endpoint);
                serializedSession = signedSerializedSession;
                signatureOk = true;
            }
            catch (SessionSignatureException e) {
                this.logger.warn((Object)("Session could not be deserialized: " + e.getMessage()));
                session = null;
            }
            if (signatureOk && serializedSession != null) {
                try {
                    session = (MuleSession)this.deserialize(message, serializedSession);
                }
                catch (SerializationException e) {
                    Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                    if (rootCause != null && (rootCause instanceof InvalidClassException || rootCause instanceof StreamCorruptedException)) {
                        this.logger.warn((Object)("Session could not be deserialized due to class incompatibility: " + e.getCause().getMessage()));
                        session = null;
                    }
                    throw e;
                }
            }
        }
        return session;
    }

    @Override
    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        String serializedEncodedSession;
        session = SECRET_KEY == null && !this.ACTIVATE_NATIVE_SESSION_SERIALIZATION ? new DefaultMuleSession() : this.removeNonSerializableProperties(session, message.getMuleContext());
        byte[] serializedSession = this.serialize(message, session);
        if (SECRET_KEY != null) {
            serializedSession = this.sign(serializedSession);
        }
        try {
            serializedEncodedSession = Base64.encodeBytes(serializedSession, 8);
        }
        catch (IOException e) {
            throw new SessionException(MessageFactory.createStaticMessage("Unable to serialize MuleSession"), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized and base64-encoded Session header to message: " + serializedEncodedSession));
        }
        message.setOutboundProperty("MULE_SESSION", serializedEncodedSession);
    }

    private byte[] getSigned(byte[] signedData, String endpoint) {
        if (SECRET_KEY == null && !this.ACTIVATE_NATIVE_SESSION_SERIALIZATION) {
            if (signedData.length > 0) {
                this.logger.warn((Object)"Trying to deserialize a session but no signature validation key specified.");
            }
            return null;
        }
        if (SECRET_KEY != null) {
            if (signedData.length < 33 || signedData[0] != 1) {
                throw new SessionSignatureException(CoreMessages.createStaticMessage("Serialized session data does not contain a signature!"));
            }
            byte[] calcHmac = new byte[32];
            byte[] data = new byte[signedData.length - 32 - 1];
            System.arraycopy(signedData, 1, calcHmac, 0, 32);
            System.arraycopy(signedData, 33, data, 0, signedData.length - 32 - 1);
            if (!Arrays.equals(calcHmac, SerializeAndEncodeSessionHandler.calcHmac(SECRET_KEY, data))) {
                throw new SessionSignatureException(CoreMessages.createStaticMessage("Signatures do not match for deserializing session!"));
            }
            return data;
        }
        return signedData;
    }

    private byte[] sign(byte[] data) {
        byte[] calcHmac = SerializeAndEncodeSessionHandler.calcHmac(SECRET_KEY, data);
        byte[] result = new byte[33 + data.length];
        result[0] = 1;
        System.arraycopy(calcHmac, 0, result, 1, 32);
        System.arraycopy(data, 0, result, 33, data.length);
        return result;
    }

    public static synchronized byte[] calcHmac(byte[] secretKey, byte[] message) {
        byte[] hmac = null;
        try {
            hmac = MAC_SIGNER.doFinal(message);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate hmac", e);
        }
        return hmac;
    }

    static {
        Log logger = LogFactory.getLog(SerializeAndEncodeSessionHandler.class);
        SECRET_KEY = System.getProperty(SESSION_SIGN_SECRET_KEY) != null ? System.getProperty(SESSION_SIGN_SECRET_KEY).getBytes(StandardCharsets.UTF_8) : (byte[])(System.getProperty(SESSION_SIGN_CH_SECRET_KEY) != null ? System.getProperty(SESSION_SIGN_CH_SECRET_KEY).getBytes(StandardCharsets.UTF_8) : null);
        if (SECRET_KEY != null) {
            try {
                String algorithm = "HmacSHA256";
                MAC_SIGNER = Mac.getInstance(algorithm);
                SecretKeySpec secretKeySpec = new SecretKeySpec(SECRET_KEY, algorithm);
                MAC_SIGNER.init(secretKeySpec);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                logger.error((Object)"Could not init class 'SerializeAndEncodeSessionHandler'", (Throwable)e);
                throw new MuleRuntimeException(e);
            }
        } else {
            MAC_SIGNER = null;
        }
    }

    private static final class SessionSignatureException
    extends MuleRuntimeException {
        private static final long serialVersionUID = 2605972894599363699L;

        public SessionSignatureException(Message message) {
            super(message);
        }
    }
}

