/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.UntilSuccessfulProcessingStrategy;
import org.mule.util.ClassUtils;

public abstract class AbstractUntilSuccessfulProcessingStrategy
implements UntilSuccessfulProcessingStrategy {
    private UntilSuccessfulConfiguration untilSuccessfulConfiguration;

    @Override
    public void setUntilSuccessfulConfiguration(UntilSuccessfulConfiguration untilSuccessfulConfiguration) {
        this.untilSuccessfulConfiguration = untilSuccessfulConfiguration;
    }

    protected MuleEvent processEvent(MuleEvent event) {
        boolean errorDetected;
        MuleEvent returnEvent;
        boolean inputEventHasExceptionPayload;
        boolean bl = inputEventHasExceptionPayload = event.getMessage().getExceptionPayload() != null;
        if (event instanceof DefaultMuleEvent) {
            event = DefaultMuleEvent.copyWithSynchronicity(event, true);
        }
        try {
            returnEvent = this.untilSuccessfulConfiguration.getRoute().process(event);
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        if (returnEvent == null || VoidMuleEvent.getInstance().equals(returnEvent)) {
            return returnEvent;
        }
        MuleMessage msg = returnEvent.getMessage();
        if (msg == null) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("No message found in response to processing, which is therefore considered failed for event: " + event));
        }
        if (!(inputEventHasExceptionPayload && this.untilSuccessfulConfiguration.isUsingDefaultExpression() || !(errorDetected = this.untilSuccessfulConfiguration.getFailureExpressionFilter().accept(msg)))) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Failure expression positive when processing event: " + event));
        }
        return returnEvent;
    }

    protected MuleEvent processResponseThroughAckResponseExpression(MuleEvent event) {
        if (event == null || VoidMuleEvent.getInstance().equals(event)) {
            return VoidMuleEvent.getInstance();
        }
        if (this.untilSuccessfulConfiguration.getAckExpression() == null) {
            return event;
        }
        event.getMessage().setPayload(this.getUntilSuccessfulConfiguration().getMuleContext().getExpressionManager().evaluate(this.getUntilSuccessfulConfiguration().getAckExpression(), event));
        return event;
    }

    protected UntilSuccessfulConfiguration getUntilSuccessfulConfiguration() {
        return this.untilSuccessfulConfiguration;
    }

    @Override
    public MuleEvent route(MuleEvent event) throws MessagingException {
        this.prepareAndValidateEvent(event);
        return this.doRoute(event);
    }

    protected abstract MuleEvent doRoute(MuleEvent var1) throws MessagingException;

    private void prepareAndValidateEvent(MuleEvent event) throws MessagingException {
        try {
            MuleMessage message = event.getMessage();
            if (message instanceof DefaultMuleMessage) {
                if (ClassUtils.isConsumable(message.getPayload().getClass())) {
                    message.getPayloadAsBytes();
                } else {
                    this.ensureSerializable(message);
                }
            } else {
                message.getPayloadAsBytes();
            }
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage("Failed to prepare message for processing"), event, e, this.getUntilSuccessfulConfiguration().getRouter());
        }
    }

    protected void ensureSerializable(MuleMessage message) throws NotSerializableException {
        if (!(message.getPayload() instanceof Serializable)) {
            throw new NotSerializableException(message.getPayload().getClass().getCanonicalName());
        }
    }

    protected void closeRetryPayload(Object retryPayload, MuleContext muleContext) {
        muleContext.getStreamCloserService().closeStream(retryPayload);
    }
}

