/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleEvent;
import org.mule.api.util.Copiable;
import org.mule.routing.MessageSequence;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.collection.EventToMessageSequenceSplittingStrategy;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class EventToMessageSequenceSplittingStrategyTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent event;
    private EventToMessageSequenceSplittingStrategy strategy = new EventToMessageSequenceSplittingStrategy();
    private Collection<String> testCollection = Arrays.asList("Apple", "Banana", "Kiwi");

    @Test
    public void copiableCollection() {
        Copiable collection = (Copiable)Mockito.mock(Copiable.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Collection.class}));
        Mockito.when((Object)collection.copy()).thenReturn(this.testCollection);
        Mockito.when((Object)this.event.getMessage().getPayload()).thenReturn((Object)collection);
        this.assertCollectionSequence();
        ((Copiable)Mockito.verify((Object)collection)).copy();
    }

    @Test
    public void nonCopiableCollection() {
        Mockito.when((Object)this.event.getMessage().getPayload()).thenReturn(this.testCollection);
        this.assertCollectionSequence();
    }

    private void assertCollectionSequence() {
        MessageSequence sequence = this.strategy.split(this.event);
        Iterator<String> expectedIterator = this.testCollection.iterator();
        while (sequence.hasNext()) {
            Assert.assertThat((Object)sequence.next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)expectedIterator.next())));
        }
    }
}

