/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.component.Component;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.ProcessorExecutor;
import org.mule.api.transformer.Transformer;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.routing.MessageFilter;

public class BlockingProcessorExecutor
implements ProcessorExecutor {
    protected final MessageProcessorExecutionTemplate messageProcessorExecutionTemplate;
    protected final boolean copyOnVoidEvent;
    protected final List<MessageProcessor> processors;
    protected MuleEvent event;
    private int index;

    public BlockingProcessorExecutor(MuleEvent event, List<MessageProcessor> processors, MessageProcessorExecutionTemplate messageProcessorExecutionTemplate, boolean copyOnVoidEvent) {
        this.event = event;
        this.processors = processors;
        this.copyOnVoidEvent = copyOnVoidEvent;
        this.messageProcessorExecutionTemplate = messageProcessorExecutionTemplate;
    }

    @Override
    public final MuleEvent execute() throws MessagingException {
        MuleEvent result = this.event;
        while (this.hasNext() && this.isEventValid(result = this.executeNext())) {
            this.event = result;
        }
        return result;
    }

    private boolean isEventValid(MuleEvent result) {
        return result != null && !(result instanceof VoidMuleEvent);
    }

    protected boolean hasNext() {
        return this.index < this.processors.size();
    }

    protected MuleEvent executeNext() throws MessagingException {
        MessageProcessor processor = this.nextProcessor();
        this.preProcess(processor);
        if (this.copyOnVoidEvent && this.processorMayReturnVoidEvent(processor)) {
            MuleEvent copy = OptimizedRequestContext.criticalSetEvent(this.event);
            MuleEvent result = this.messageProcessorExecutionTemplate.execute(processor, this.event);
            if (this.isUseEventCopy(result)) {
                result = copy;
            }
            return result;
        }
        return this.messageProcessorExecutionTemplate.execute(processor, this.event);
    }

    protected boolean isUseEventCopy(MuleEvent result) {
        return VoidMuleEvent.getInstance().equals(result);
    }

    protected void preProcess(MessageProcessor processor) {
    }

    protected MessageProcessor nextProcessor() {
        return this.processors.get(this.index++);
    }

    private boolean processorMayReturnVoidEvent(MessageProcessor processor) {
        if (processor instanceof OutboundEndpoint) {
            MessageExchangePattern exchangePattern = ((OutboundEndpoint)processor).getExchangePattern();
            return exchangePattern == null ? true : !exchangePattern.hasResponse();
        }
        return !(processor instanceof Component) && !(processor instanceof Transformer) && !(processor instanceof MessageFilter);
    }
}

