/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.RequiredValueException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.filters.WildcardFilter;

public class MessageAttachmentsExpressionEvaluator
implements ExpressionEvaluator {
    public static final String NAME = "attachments";

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        HashMap<String, DataHandler> result;
        if (expression.contains("*")) {
            WildcardFilter filter = new WildcardFilter(expression);
            result = new HashMap<String, DataHandler>(message.getInboundAttachmentNames().size());
            for (String name : message.getInboundAttachmentNames()) {
                if (!filter.accept(name)) continue;
                result.put(name, message.getInboundAttachment(name));
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(expression, ",");
            result = new HashMap(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                boolean required;
                String s = tokenizer.nextToken();
                if ((s = s.trim()).endsWith("?")) {
                    s = s.substring(0, s.length() - "?".length());
                    required = false;
                } else {
                    required = true;
                }
                DataHandler val = message.getInboundAttachment(s);
                if (val != null) {
                    result.put(s, val);
                    continue;
                }
                if (!required) continue;
                throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(NAME, expression));
            }
        }
        if (result.size() == 0) {
            return Collections.unmodifiableMap(Collections.emptyMap());
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

