/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.config.pool.ThreadPoolFactory;

public class MutableThreadingProfile
implements ThreadingProfile {
    private int maxThreadsActive;
    private int maxThreadsIdle;
    private int maxBufferSize;
    private long threadTTL;
    private long threadWaitTimeout;
    private int poolExhaustedAction;
    private boolean doThreading;
    private ThreadPoolFactory poolFactory;
    private ThreadingProfile.WorkManagerFactory workManagerFactory;
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;
    private MuleContext muleContext;

    public MutableThreadingProfile(ThreadingProfile tp) {
        this.maxThreadsActive = tp.getMaxThreadsActive();
        this.maxThreadsIdle = tp.getMaxThreadsIdle();
        this.maxBufferSize = tp.getMaxBufferSize();
        this.threadTTL = tp.getThreadTTL();
        this.threadWaitTimeout = tp.getThreadWaitTimeout();
        this.poolExhaustedAction = tp.getPoolExhaustedAction();
        this.doThreading = tp.isDoThreading();
        this.rejectedExecutionHandler = tp.getRejectedExecutionHandler();
        this.threadFactory = tp.getThreadFactory();
        this.workManagerFactory = tp.getWorkManagerFactory();
        this.poolFactory = tp.getPoolFactory();
    }

    @Override
    public ExecutorService createPool() {
        return this.createPool(null);
    }

    @Override
    public int getMaxThreadsActive() {
        return this.maxThreadsActive;
    }

    @Override
    public int getMaxThreadsIdle() {
        return this.maxThreadsIdle;
    }

    @Override
    public long getThreadTTL() {
        return this.threadTTL;
    }

    @Override
    public long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    @Override
    public int getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void setMaxThreadsActive(int maxThreadsActive) {
        this.maxThreadsActive = maxThreadsActive;
    }

    @Override
    public void setMaxThreadsIdle(int maxThreadsIdle) {
        this.maxThreadsIdle = maxThreadsIdle;
    }

    @Override
    public void setThreadTTL(long threadTTL) {
        this.threadTTL = threadTTL;
    }

    @Override
    public void setThreadWaitTimeout(long threadWaitTimeout) {
        this.threadWaitTimeout = threadWaitTimeout;
    }

    @Override
    public void setPoolExhaustedAction(int poolExhaustedAction) {
        this.poolExhaustedAction = poolExhaustedAction;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @Override
    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public ThreadingProfile.WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    @Override
    public void setWorkManagerFactory(ThreadingProfile.WorkManagerFactory workManagerFactory) {
        this.workManagerFactory = workManagerFactory;
    }

    @Override
    public WorkManager createWorkManager(String name, int shutdownTimeout) {
        return this.workManagerFactory.createWorkManager(new ImmutableThreadingProfile(this), name, shutdownTimeout);
    }

    @Override
    public ExecutorService createPool(String name) {
        return this.poolFactory.createPool(name, new ImmutableThreadingProfile(this));
    }

    @Override
    public boolean isDoThreading() {
        return this.doThreading;
    }

    @Override
    public void setDoThreading(boolean doThreading) {
        this.doThreading = doThreading;
    }

    @Override
    public ThreadPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    @Override
    public ScheduledExecutorService createScheduledPool(String name) {
        return this.poolFactory.createScheduledPool(name, new ImmutableThreadingProfile(this));
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

