/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.ExceptionHelper;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.NullPayload;
import org.mule.util.StringUtils;

public class MessagingException
extends MuleException {
    private static final long serialVersionUID = 6941498759267936649L;
    protected transient MuleMessage muleMessage;
    protected final transient MuleEvent event;
    protected transient MuleEvent processedEvent;
    private boolean causeRollback;
    private boolean handled;
    private transient MessageProcessor failingMessageProcessor;

    @Deprecated
    public MessagingException(Message message, MuleMessage muleMessage) {
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event) {
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event, MessageProcessor failingMessageProcessor) {
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(message));
    }

    @Deprecated
    public MessagingException(Message message, MuleMessage muleMessage, Throwable cause) {
        super(cause);
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event, Throwable cause) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event, Throwable cause, MessageProcessor failingMessageProcessor) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(MuleEvent event, Throwable cause) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(this.getI18nMessage()));
    }

    public MessagingException(MuleEvent event, Throwable cause, MessageProcessor failingMessageProcessor) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(this.getI18nMessage()));
    }

    private String generateMessage(Message message) {
        StringBuilder buf = new StringBuilder(80);
        if (message != null) {
            buf.append(message.getMessage()).append(". ");
        }
        if (this.muleMessage != null) {
            Object payload = this.muleMessage.getPayload();
            if (payload == null) {
                payload = NullPayload.getInstance();
            }
            buf.append(CoreMessages.messageIsOfType(payload.getClass()).getMessage());
            this.addInfo("Payload", StringUtils.abbreviate((String)payload.toString(), (int)1000));
        } else {
            buf.append("The current MuleMessage is null! Please report this to ").append(MuleManifest.getDevListEmail());
            this.addInfo("Payload", NullPayload.getInstance().toString());
        }
        return buf.toString();
    }

    @Deprecated
    public MuleMessage getMuleMessage() {
        if (this.getEvent() != null) {
            return this.event.getMessage();
        }
        return this.muleMessage;
    }

    public MuleEvent getEvent() {
        return this.processedEvent != null && !VoidMuleEvent.getInstance().equals(this.processedEvent) ? this.processedEvent : this.event;
    }

    public void setProcessedEvent(MuleEvent processedEvent) {
        if (processedEvent != null && !VoidMuleEvent.getInstance().equals(processedEvent)) {
            this.processedEvent = processedEvent;
            this.muleMessage = this.processedEvent.getMessage();
        } else {
            this.processedEvent = null;
            this.muleMessage = null;
        }
    }

    public boolean causedBy(final Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, new ExceptionHelper.ExceptionEvaluator<Object>(){

            @Override
            public Object evaluate(Throwable causeException) {
                if (e.isAssignableFrom(causeException.getClass())) {
                    return causeException;
                }
                return null;
            }
        }) != null;
    }

    public boolean causedExactlyBy(final Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, new ExceptionHelper.ExceptionEvaluator<Object>(){

            @Override
            public Object evaluate(Throwable causeException) {
                if (causeException.getClass().equals(e)) {
                    return causeException;
                }
                return null;
            }
        }) != null;
    }

    public Exception getCauseException() {
        Throwable rootException = ExceptionHelper.getRootException(this);
        if (rootException == null) {
            rootException = this;
        }
        return (Exception)rootException;
    }

    public boolean causeMatches(final String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("regex cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, new ExceptionHelper.ExceptionEvaluator<Object>(){

            @Override
            public Object evaluate(Throwable e) {
                WildcardFilter wildcardFilter = new WildcardFilter(regex);
                if (wildcardFilter.accept(e.getClass().getName())) {
                    return e;
                }
                try {
                    RegExFilter regExFilter = new RegExFilter(regex);
                    if (regExFilter.accept(e.getClass().getName())) {
                        return e;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }) != null;
    }

    public boolean causedRollback() {
        return this.causeRollback;
    }

    public void setCauseRollback(boolean causeRollback) {
        this.causeRollback = causeRollback;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean handled() {
        return this.handled;
    }

    public MessageProcessor getFailingMessageProcessor() {
        return this.failingMessageProcessor;
    }

    protected void extractMuleMessage(MuleEvent event) {
        this.muleMessage = event == null || VoidMuleEvent.getInstance().equals(event) ? null : event.getMessage();
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.failingMessageProcessor instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.failingMessageProcessor);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean failingMessageProcessorWasSerialized = in.readBoolean();
        if (failingMessageProcessorWasSerialized) {
            this.failingMessageProcessor = (MessageProcessor)in.readObject();
        }
    }
}

