/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.watermark;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;

public abstract class WatermarkUtils {
    public static Serializable evaluate(String expression, MuleEvent event) throws NotSerializableException {
        ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
        if (expressionManager.isExpression(expression) && expressionManager.isValidExpression(expression)) {
            Object evaluated = expressionManager.evaluate(expression, event);
            if (evaluated != null && !(evaluated instanceof Serializable)) {
                throw new NotSerializableException(String.format("Expression %s resolves to an object that is not serializable (%s). It can't be used as watermark.", expression, evaluated.getClass().getCanonicalName()));
            }
            return (Serializable)evaluated;
        }
        return expression;
    }
}

