/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.mule.api.expression.ExpressionManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.StringUtils;

public class ExpressionConfig {
    public static final String CUSTOM_EVALUATOR = "custom";
    public static final String EXPRESSION_SEPARATOR = ":";
    private String unParsedExpression;
    private String expression;
    private String evaluator;
    private String customEvaluator;
    private String fullExpression;
    private String expressionPrefix = "#[";
    private String expressionPostfix = "]";

    public ExpressionConfig() {
    }

    public ExpressionConfig(String expression, String evaluator, String customEvaluator) {
        this(expression, evaluator, customEvaluator, "#[", "]");
    }

    public ExpressionConfig(String expression, String evaluator, String customEvaluator, String expressionPrefix, String expressionPostfix) {
        this.setCustomEvaluator(customEvaluator);
        this.setEvaluator(evaluator);
        this.setExpression(expression);
        this.expressionPostfix = expressionPostfix;
        this.expressionPrefix = expressionPrefix;
    }

    public void parse(String expressionString) {
        int i;
        if (expressionString.startsWith(this.expressionPrefix) && this.evaluator == null) {
            expressionString = expressionString.substring(this.expressionPrefix.length());
            expressionString = expressionString.substring(0, expressionString.length() - this.expressionPostfix.length());
        }
        if ((i = expressionString.indexOf(EXPRESSION_SEPARATOR)) >= 0 && this.evaluator == null) {
            String candidateEvaluator = expressionString.substring(0, i);
            if (!candidateEvaluator.matches("^[\\w-_]+$")) {
                this.expression = expressionString;
            } else {
                this.evaluator = expressionString.substring(0, i);
                this.expression = expressionString.substring(i + 1);
            }
        } else {
            this.expression = expressionString;
        }
    }

    public void validate(ExpressionManager manager) {
        if (this.expression == null) {
            this.parse(this.unParsedExpression);
        }
        if (this.expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (CUSTOM_EVALUATOR.equalsIgnoreCase(this.evaluator)) {
            if (this.customEvaluator == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("custom evaluator").getMessage());
            }
            this.evaluator = this.customEvaluator;
        }
        if (this.evaluator != null && !manager.isEvaluatorRegistered(this.evaluator)) {
            throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(this.evaluator).getMessage());
        }
    }

    public String getFullExpression(ExpressionManager manager) {
        if (this.fullExpression == null) {
            if (this.expression == null) {
                this.parse(this.unParsedExpression);
            }
            this.validate(manager);
            this.fullExpression = this.evaluator != null ? this.expressionPrefix + this.evaluator + EXPRESSION_SEPARATOR + this.expression + this.expressionPostfix : this.expressionPrefix + this.expression + this.expressionPostfix;
        }
        return this.fullExpression;
    }

    public String getCustomEvaluator() {
        if (this.expression == null) {
            this.parse(this.unParsedExpression);
        }
        return this.customEvaluator;
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.customEvaluator = StringUtils.trimToNull((String)customEvaluator);
        this.fullExpression = null;
    }

    public String getEvaluator() {
        if (this.expression == null) {
            this.parse(this.unParsedExpression);
        }
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = StringUtils.trimToNull((String)evaluator);
        this.fullExpression = null;
    }

    public String getExpression() {
        if (this.expression == null) {
            this.parse(this.unParsedExpression);
        }
        return this.expression;
    }

    public void setExpression(String expression) {
        this.unParsedExpression = expression;
        this.expression = null;
        this.fullExpression = null;
    }
}

