/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractConfigurationPattern;
import org.mule.util.ClassUtils;

public class SimpleService
extends AbstractConfigurationPattern {
    private final Component component;
    private final Type type;

    public SimpleService(String name, MuleContext muleContext, MessageSource messageSource, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers, Component component, Type type) throws MuleException {
        super(name, muleContext, transformers, responseTransformers);
        if (messageSource == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("messageSource can't be null on: " + this.toString()));
        }
        if (component == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("component can't be null on: " + this.toString()));
        }
        if (type == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("type can't be null on: " + this.toString()));
        }
        this.messageSource = messageSource;
        this.component = component;
        this.type = type;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    protected void configureMessageProcessorsBeforeTransformation(MessageProcessorChainBuilder builder) {
    }

    @Override
    protected void configureMessageProcessorsAfterTransformation(MessageProcessorChainBuilder builder) {
        this.type.configureComponentMessageProcessor(this.muleContext, builder, this.component);
    }

    @Override
    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        if (this.messageSource instanceof InboundEndpoint && !((InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("SimpleService only works with a request-response inbound endpoint."), this);
        }
        this.type.validate(this.component);
    }

    private static Class<?> getComponentClass(Component component) {
        if (component instanceof JavaComponent) {
            return ((JavaComponent)component).getObjectFactory().getObjectClass();
        }
        return component.getClass();
    }

    private static MessageProcessor newJaxWsComponentMessageProcessor(MuleContext muleContext, Class<?> componentClass) {
        try {
            MessageProcessorBuilder wsmpb = (MessageProcessorBuilder)ClassUtils.instanciateClass("org.mule.module.cxf.builder.WebServiceMessageProcessorBuilder", new Object[0]);
            Method setServiceClassMethod = ClassUtils.getMethod(wsmpb.getClass(), "setServiceClass", new Class[]{Class.class});
            setServiceClassMethod.invoke((Object)wsmpb, componentClass);
            Method setFrontendMethod = ClassUtils.getMethod(wsmpb.getClass(), "setFrontend", new Class[]{String.class});
            setFrontendMethod.invoke((Object)wsmpb, "jaxws");
            ((MuleContextAware)((Object)wsmpb)).setMuleContext(muleContext);
            return wsmpb.build();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Failed to configure the required web service infrastructure: are you missing the Mule CXF Module?"), (Throwable)e);
        }
    }

    private static Component newJaxRsComponentWrapper(MuleContext muleContext, Component component) {
        try {
            Component jrc = (Component)ClassUtils.instanciateClass("org.mule.module.jersey.JerseyResourcesComponent", new Object[0]);
            Method setComponentsMethod = ClassUtils.getMethod(jrc.getClass(), "setComponents", new Class[]{List.class});
            setComponentsMethod.invoke((Object)jrc, Collections.singletonList(component));
            ((MuleContextAware)((Object)jrc)).setMuleContext(muleContext);
            return jrc;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Failed to configure the required web service infrastructure: are you missing the Mule Jersey Module?"), (Throwable)e);
        }
    }

    @Override
    public String getConstructType() {
        return "Simple-Service";
    }

    public static enum Type {
        JAX_WS{

            @Override
            public void validate(Component component) throws FlowConstructInvalidException {
                if (!(component instanceof JavaComponent)) {
                    throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("SimpleService can only expose instances of JAX-WS annotated JavaComponent instances. You provided a: " + component.getClass().getName()));
                }
            }

            @Override
            public void configureComponentMessageProcessor(MuleContext muleContext, MessageProcessorChainBuilder builder, Component component) {
                builder.chain(SimpleService.newJaxWsComponentMessageProcessor(muleContext, SimpleService.getComponentClass(component)));
                builder.chain(component);
            }
        }
        ,
        JAX_RS{

            @Override
            public void validate(Component component) throws FlowConstructInvalidException {
                if (!(component instanceof JavaComponent)) {
                    throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("SimpleService can only expose instances of JAX-RS annotated JavaComponent instances. You provided a: " + component.getClass().getName()));
                }
            }

            @Override
            public void configureComponentMessageProcessor(MuleContext muleContext, MessageProcessorChainBuilder builder, Component component) {
                builder.chain(SimpleService.newJaxRsComponentWrapper(muleContext, component));
            }
        }
        ,
        DIRECT{

            @Override
            public void validate(Component component) throws FlowConstructInvalidException {
            }

            @Override
            public void configureComponentMessageProcessor(MuleContext muleContext, MessageProcessorChainBuilder builder, Component component) {
                builder.chain(component);
            }
        };


        public abstract void validate(Component var1) throws FlowConstructInvalidException;

        public abstract void configureComponentMessageProcessor(MuleContext var1, MessageProcessorChainBuilder var2, Component var3);

        public static Type fromString(String string) {
            String mepString = string.toUpperCase().replace('-', '_');
            return Type.valueOf(mepString);
        }
    }
}

